/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.servlet;

import io.lightlink.output.JSONHttpResponseStream;
import io.lightlink.security.CSRFTokensContainer;
import io.lightlink.servlet.AbstractLightLinkServlet;
import io.lightlink.spring.LightLinkFilter;
import io.lightlink.spring.StreamingResponseData;
import io.lightlink.utils.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestServlet
extends AbstractLightLinkServlet {
    protected void doServide(String method, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inputParams) throws IOException {
        String actionName = this.getAction(req);
        if (Utils.isFirstNonAlphabetic(actionName)) {
            return;
        }
        this.getScriptRunner(req, resp).execute(actionName, method, inputParams, new JSONHttpResponseStream(resp));
    }

    protected Map<String, Object> getParams(HttpServletRequest req) throws IOException {
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            String[] value = (String[])entry.getValue();
            if (value != null && value.length == 1) {
                inputParams.put((String)entry.getKey(), value[0]);
                continue;
            }
            inputParams.put((String)entry.getKey(), value);
        }
        return inputParams;
    }

    protected String getAction(HttpServletRequest req) {
        String servletPath = req.getServletPath();
        int pos = req.getRequestURI().indexOf(servletPath);
        String res = req.getRequestURI().substring(pos + servletPath.length());
        return res.replaceAll("\\.xlsx$", "");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service("GET", req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service("POST", req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service("PUT", req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.service("DELETE", req, resp);
    }

    protected void service(String method, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LightLinkFilter.setThreadLocalStreamingData(new StreamingResponseData(req, resp));
        Map<String, Object> params = this.getParams(req);
        CSRFTokensContainer tokensContainer = CSRFTokensContainer.getInstance(req.getSession());
        String token = tokensContainer.validate(params);
        if (token == null) {
            tokensContainer.sendCsrfError(resp);
            return;
        }
        resp.setContentType("application/json; charset=UTF-8");
        this.doServide(method, req, resp, params);
    }
}

