/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.servlet.debug;

import io.lightlink.output.JSONHttpResponseStream;
import io.lightlink.output.ResponseStream;
import io.lightlink.servlet.debug.HttpRequestPlaceholder;
import io.lightlink.servlet.debug.MethodOrConstructorWrapper;
import io.lightlink.servlet.debug.ObjectPoolElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugFacadesProxyServlet
extends HttpServlet {
    public static final Logger LOG = LoggerFactory.getLogger(DebugFacadesProxyServlet.class);
    AtomicInteger nextObjectId = new AtomicInteger(1);
    HashMap<Integer, ObjectPoolElement> pool = new HashMap();
    TreeSet<Long> generations = new TreeSet();

    public DebugFacadesProxyServlet() {
        boolean x = false;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.doGet(req, resp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Map params = this.getJsonParamsMap(request);
            JSONHttpResponseStream json = new JSONHttpResponseStream(response);
            this.dispatch(request, params, json);
        }
        catch (Exception e) {
            this.sendError(response, e);
        }
    }

    void dispatch(HttpServletRequest request, Map params, ResponseStream json) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        if ("create".equals(params.get("action"))) {
            this.create(params, json);
        } else if ("createClass".equals(params.get("action"))) {
            this.createClass(params, json);
        } else if ("invoke".equals(params.get("action"))) {
            this.invoke(request, params, json);
        }
    }

    private void sendError(HttpServletResponse response, Exception e) throws IOException {
        LOG.error(e.toString(), (Throwable)e);
        JSONHttpResponseStream json = new JSONHttpResponseStream(response);
        json.writeProperty("exception", e.getClass().getName());
        json.writeProperty("message", e.toString());
        StringWriter traceWriter = new StringWriter(1024);
        PrintWriter pw = new PrintWriter(traceWriter);
        e.printStackTrace(pw);
        pw.close();
        json.writeProperty("stackTrace", traceWriter.toString());
        json.end();
    }

    private void invoke(HttpServletRequest request, Map params, ResponseStream json) throws IllegalAccessException, InvocationTargetException, IOException {
        String methodName = (String)params.get("methodName");
        Integer objectId = ((Number)params.get("objectId")).intValue();
        List args = (List)params.get("args");
        this.replaceStubsByObjects(args);
        ObjectPoolElement element = this.pool.get(objectId);
        Object instance = element.getObject();
        if (instance instanceof HttpRequestPlaceholder) {
            instance = request;
        }
        Class<?> cls = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        Method[] allMethods = cls.getMethods();
        ArrayList<Method> sameName = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (!methodName.equals(method.getName())) continue;
            sameName.add(method);
        }
        Object[] methods = sameName.toArray(new Method[sameName.size()]);
        MethodOrConstructorWrapper method = this.findMethod(args, MethodOrConstructorWrapper.getArray(methods));
        if (method == null) {
            throw new RuntimeException("Cannot find method:" + methodName + " for class:" + cls + " wiht parameters: " + args);
        }
        Object resp = this.invokeMethod(args, instance, method.getMethod());
        this.returnObject(resp, element.getGeneration(), json);
    }

    private Object invokeMethod(List args, Object instance, Method method) throws IllegalAccessException, InvocationTargetException {
        Object[] argsArray = args.toArray();
        Class<?>[] pTypes = method.getParameterTypes();
        for (int i = 0; i < argsArray.length; ++i) {
            Object arg = argsArray[i];
            if (!(arg instanceof Object[]) || !pTypes[i].equals(byte[].class)) continue;
            Object[] argObjArray = (Object[])arg;
            byte[] bytes = new byte[argObjArray.length];
            for (int j = 0; j < argObjArray.length; ++j) {
                bytes[j] = ((Number)argObjArray[j]).byteValue();
            }
            argsArray[i] = bytes;
        }
        return method.invoke(instance, argsArray);
    }

    private void createClass(Map params, ResponseStream json) throws ClassNotFoundException, IOException {
        this.purgeGenerations();
        String className = (String)params.get("className");
        Long generation = new Long("" + params.get("generation"));
        Class<?> aClass = Class.forName(className);
        this.returnObject(aClass, generation, json);
    }

    private void create(Map params, ResponseStream json) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, IOException {
        String className = (String)params.get("className");
        Long generation = new Long("" + params.get("generation"));
        List args = (List)params.get("args");
        this.replaceStubsByObjects(args);
        Object[] candidates = Class.forName(className).getConstructors();
        MethodOrConstructorWrapper constructor = this.findMethod(args, MethodOrConstructorWrapper.getArray(candidates));
        if (constructor == null) {
            throw new RuntimeException("Cannot find constructor for class:" + className + " wiht parameters: " + args);
        }
        Object instance = constructor.getConstructor().newInstance(args.toArray());
        this.returnObject(instance, generation, json);
    }

    private Map getJsonParamsMap(HttpServletRequest request) throws IOException {
        Map params;
        ServletInputStream inputStream = request.getInputStream();
        try {
            params = (Map)new JSONParser().parse((Reader)new InputStreamReader((InputStream)inputStream, "UTF-8"));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        inputStream.close();
        return params;
    }

    private void returnObject(Object instance, Long generation, ResponseStream json) throws IOException {
        this.writeGenericInstance(instance, generation, json);
        json.end();
    }

    private void writeGenericInstance(Object instance, Long generation, ResponseStream json) throws IOException {
        if (instance == null || instance instanceof String || instance instanceof Number || instance.getClass().isArray() && (instance.getClass().getComponentType().isPrimitive() || instance.getClass().getComponentType().isInstance(Number.class) || instance.getClass().getComponentType().isInstance(String.class))) {
            this.writeSimpleType(instance, json);
        } else if (instance instanceof Map) {
            this.writeArray((Map)instance, generation, json);
        } else if (instance instanceof Collection) {
            this.writeObject((Collection)instance, generation, json);
        } else {
            this.writePooledObject(instance, generation, json);
        }
    }

    private void writeObject(Collection instance, Long generation, ResponseStream json) throws IOException {
        json.writeProperty("type", "array");
        Collection map = instance;
        json.writePropertyArrayStart("values");
        for (Object el : map) {
            json.writeObjectStart();
            this.writeGenericInstance(el, generation, json);
            json.writeObjectEnd();
        }
        json.writePropertyArrayEnd();
    }

    private void writeArray(Map<Object, Object> instance, Long generation, ResponseStream json) throws IOException {
        json.writeProperty("type", "map");
        Map<Object, Object> map = instance;
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            json.writePropertyObjectStart("" + entry.getKey());
            this.writeGenericInstance(entry.getValue(), generation, json);
            json.writePropertyObjectEnd();
        }
    }

    private void writePooledObject(Object instance, Long generation, ResponseStream json) throws IOException {
        ObjectPoolElement[] elements;
        int objectId = -1;
        for (ObjectPoolElement element : elements = this.pool.values().toArray(new ObjectPoolElement[0])) {
            if (element.getObject() != instance) continue;
            objectId = element.getObjectId();
            break;
        }
        if (objectId == -1) {
            objectId = this.nextObjectId.getAndIncrement();
            this.pool.put(objectId, new ObjectPoolElement(generation, objectId, instance));
        }
        json.writeProperty("type", "pooled");
        json.writeProperty("objectId", objectId);
        boolean isClass = instance instanceof Class;
        if (isClass) {
            json.writeProperty("className", ((Class)instance).getName());
        }
        HashSet<String> methods = new HashSet<String>();
        for (Method method : (isClass ? (Class<?>)instance : instance.getClass()).getMethods()) {
            if (isClass) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                methods.add(method.getName());
                continue;
            }
            methods.add(method.getName());
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (Field field : (isClass ? (Class<?>)instance : instance.getClass()).getFields()) {
            if (isClass && !Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object value = field.get(instance);
                if (!(value instanceof Number) && !(value instanceof String) && !(value instanceof Boolean)) continue;
                fields.put(field.getName(), value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        json.writeProperty("methods", new ArrayList(methods));
        json.writeProperty("fields", fields);
    }

    private void writeSimpleType(Object instance, ResponseStream json) throws IOException {
        json.writeProperty("type", "simple");
        json.writeProperty("value", instance);
    }

    private MethodOrConstructorWrapper findMethod(List args, MethodOrConstructorWrapper[] methods) {
        ArrayList<MethodOrConstructorWrapper> candidates = new ArrayList<MethodOrConstructorWrapper>();
        for (MethodOrConstructorWrapper c : methods) {
            if (c.getParameterTypes().length != args.size()) continue;
            candidates.add(c);
        }
        if (candidates.size() == 0) {
            return null;
        }
        block1: for (MethodOrConstructorWrapper candidate : candidates) {
            Class<?>[] parameterTypes = candidate.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Object arg = args.get(i);
                Class<?> t = parameterTypes[i];
                if (arg != null && arg instanceof Long) {
                    arg = this.getSmallestNumericType((Long)arg);
                    args.set(i, arg);
                    if (t == Integer.TYPE || t == Long.TYPE || t == Byte.TYPE || t == Short.TYPE || t == Integer.class || t == Long.class || t == Byte.class || t == Short.class || t == Number.class || t == Object.class) continue;
                    continue block1;
                }
                if (arg != null && arg instanceof Double) {
                    if (t == Double.TYPE || t == Double.class || t == Float.TYPE || t == Float.class || t == Object.class) continue;
                    continue block1;
                }
                if (arg != null && arg instanceof Boolean) {
                    if (t == Boolean.class || t == Boolean.TYPE || t == Object.class) continue;
                    continue block1;
                }
                if (arg instanceof JSONArray) {
                    JSONArray arr = (JSONArray)arg;
                    Object[] array = arr.toArray();
                    for (int j = 0; j < array.length; ++j) {
                        Object o = array[j];
                        if (!(o instanceof Long)) continue;
                        array[j] = this.getSmallestNumericType((Long)o);
                    }
                    args.set(i, array);
                    continue;
                }
                if (arg != null && !t.isAssignableFrom(arg.getClass())) continue block1;
            }
            return candidate;
        }
        return null;
    }

    private Object getSmallestNumericType(Long arg) {
        if (arg < 127L) {
            return arg.byteValue();
        }
        if (arg < 32767L) {
            return arg.shortValue();
        }
        if (arg < Integer.MAX_VALUE) {
            return arg.intValue();
        }
        return arg;
    }

    private void replaceStubsByObjects(List args) {
        for (int i = 0; i < args.size(); ++i) {
            Number objectId;
            Object arg = args.get(i);
            if (!(arg instanceof Map) || (objectId = (Number)((Map)arg).get("objectId")) == null) continue;
            args.set(i, this.pool.get(objectId.intValue()).getObject());
        }
    }

    public void purgeGenerations() {
        while (this.generations.size() > 10) {
            long genToRemove = this.generations.pollFirst();
            Iterator<Map.Entry<Integer, ObjectPoolElement>> iterator = this.pool.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Integer, ObjectPoolElement> entry = iterator.next();
                if (entry.getValue().getGeneration() != genToRemove) continue;
                iterator.remove();
            }
        }
    }
}

