/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.spring;

import io.lightlink.config.ConfigManager;
import io.lightlink.output.HttpResponseStream;
import io.lightlink.output.ResponseStream;
import io.lightlink.spring.StreamingResponseData;
import io.lightlink.utils.LogUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LightLinkFilter
implements Filter {
    private static ThreadLocal<StreamingResponseData> threadLocalInstance = new ThreadLocal();

    public static boolean isThreadLocalStreamingDataSet() {
        return threadLocalInstance.get() != null;
    }

    public static StreamingResponseData getThreadLocalStreamingData() {
        StreamingResponseData res = threadLocalInstance.get();
        if (res == null) {
            throw new IllegalStateException("LightLinkFilter must be mapped to this URL.");
        }
        return res;
    }

    public static void setThreadLocalStreamingData(StreamingResponseData streamingData) {
        threadLocalInstance.set(streamingData);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StreamingResponseData responseData = new StreamingResponseData((HttpServletRequest)request, (HttpServletResponse)response);
        try {
            threadLocalInstance.set(responseData);
            responseData.setProgressiveSlices(null);
            try {
                chain.doFilter(request, response);
            }
            catch (RuntimeException e) {
                this.reportError(responseData, e);
                throw e;
            }
            catch (IOException e) {
                this.reportError(responseData, e);
                throw e;
            }
            catch (ServletException e) {
                this.reportError(responseData, e);
                throw e;
            }
            if (responseData.isResponseStreamInitiated()) {
                HttpResponseStream responseStream = responseData.getResponseStream();
                responseStream.writeProperty("success", true);
                responseStream.end();
            }
        }
        finally {
            responseData.end();
        }
    }

    public static ResponseStream getCurrentResponseStream() {
        return threadLocalInstance.get().getResponseStream();
    }

    private void reportError(StreamingResponseData responseData, Throwable e) {
        HttpResponseStream stream = responseData.getResponseStream();
        stream.writeProperty("success", false);
        if (e != null) {
            LogUtils.error(this.getClass(), e);
            stream.writeProperty("exception", e.toString());
            if (ConfigManager.isInDebugMode()) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                stream.writeProperty("stackTrace", sw.toString());
            }
        }
        stream.end();
    }
}

