/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.spring;

import io.lightlink.output.ResponseStream;
import io.lightlink.sql.SQLHandler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.beanutils.BeanMap;
import org.springframework.jdbc.core.RowMapper;

public class StreamingMapper
implements RowMapper<Object> {
    private RowMapper nestedRowMapper;
    private String resultPropertyName;
    private int colCount;
    private String[] colNames;
    private ResponseStream responseStream;

    public StreamingMapper(ResponseStream responseStream) {
        this(responseStream, null);
    }

    public StreamingMapper(ResponseStream responseStream, RowMapper nestedRowMapper) {
        this.nestedRowMapper = nestedRowMapper;
        this.responseStream = responseStream;
    }

    public Object mapRow(ResultSet resultSet, int i) throws SQLException {
        if (this.nestedRowMapper != null) {
            Object row = this.nestedRowMapper.mapRow(resultSet, i);
            this.responseStream.writeFullObjectToArray(new BeanMap(row));
        } else {
            if (this.colCount == 0) {
                this.readMetadata(resultSet);
            }
            this.responseStream.writeObjectStart();
            for (int j = 0; j < this.colCount; ++j) {
                Object value = resultSet.getObject(j + 1);
                Object converted = SQLHandler.genericConvertFromJdbc(null, value);
                this.responseStream.writeProperty(this.colNames[j], converted);
            }
            this.responseStream.writeObjectEnd();
        }
        return null;
    }

    private void readMetadata(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        this.colCount = metaData.getColumnCount();
        this.colNames = new String[this.colCount];
        for (int i = 0; i < this.colNames.length; ++i) {
            this.colNames[i] = metaData.getColumnLabel(i + 1);
        }
    }
}

