/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.spring;

import io.lightlink.core.Hints;
import io.lightlink.output.HttpResponseStream;
import io.lightlink.output.JSONHttpResponseStream;
import io.lightlink.output.async.AsyncHttpResponseStreamRunnable;
import io.lightlink.utils.LogUtils;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class StreamingResponseData {
    private static ExecutorService executorService = Executors.newCachedThreadPool();
    private Hints hints;
    private HttpResponseStream responseStream;
    private int[] progressiveSlices;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;
    private AsyncHttpResponseStreamRunnable runnable;
    private Future<?> taskFuture;

    public StreamingResponseData(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        this.servletRequest = servletRequest;
        this.servletResponse = servletResponse;
        if (servletRequest != null) {
            this.hints = Hints.fromRequest(servletRequest);
        }
    }

    public Hints getHints() {
        return this.hints;
    }

    public boolean isResponseStreamInitiated() {
        return this.responseStream != null;
    }

    public HttpResponseStream getResponseStream() {
        if (this.responseStream == null) {
            try {
                this.runnable = new AsyncHttpResponseStreamRunnable(new JSONHttpResponseStream(this.servletResponse));
                this.taskFuture = executorService.submit(this.runnable);
                this.responseStream = this.runnable.getFacade();
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString(), e);
            }
        }
        return this.responseStream;
    }

    public int[] getProgressiveSlices() {
        return this.progressiveSlices;
    }

    public void setProgressiveSlices(int[] progressiveSlices) {
        this.progressiveSlices = progressiveSlices;
    }

    public HttpServletResponse getServletResponse() {
        return this.servletResponse;
    }

    public void end() {
        if (this.isResponseStreamInitiated()) {
            this.responseStream.end();
            try {
                this.taskFuture.get();
            }
            catch (InterruptedException e) {
                LogUtils.error(this.getClass(), e);
            }
            catch (ExecutionException e) {
                LogUtils.error(this.getClass(), e);
            }
        }
    }
}

