/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.sql;

import io.lightlink.autostop.AutoStopQuery;
import io.lightlink.core.RunnerContext;
import io.lightlink.facades.SQLFacade;
import io.lightlink.output.ResponseStream;
import io.lightlink.translator.ScriptTranslator;
import io.lightlink.types.AbstractConverter;
import io.lightlink.types.ArgInfo;
import io.lightlink.types.ArrayConverter;
import io.lightlink.types.BlobConverter;
import io.lightlink.types.DateConverter;
import io.lightlink.types.JSONConverter;
import io.lightlink.types.NumberConverter;
import io.lightlink.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLHandler {
    public static final Logger LOG = LoggerFactory.getLogger(SQLHandler.class);
    PreparedStatement batchPS;
    CallableStatement batchCS;
    List<ArgInfo> batchArgInfos;
    private String batchSQL;
    private SQLFacade facade;

    public SQLHandler(SQLFacade facade) {
        this.facade = facade;
        this.facade = facade;
    }

    public void query(boolean addBatch, String resultSetName, RunnerContext runnerContext, String sql, JSObject rowHandler) throws SQLException, IOException, ScriptException {
        LOG.info("SQL:" + sql);
        if (sql == null || Utils.isBlank(sql)) {
            if (!addBatch && this.batchPS != null) {
                this.batchPS.addBatch();
                int[] updateCounts = this.batchPS.executeBatch();
                ArrayList<Integer> updateCountList = new ArrayList<Integer>(updateCounts.length);
                for (int updateCount : updateCounts) {
                    updateCountList.add(updateCount);
                }
                this.facade.setUpdateCount(updateCountList);
                this.batchCS = null;
                this.batchPS = null;
            }
            return;
        }
        Connection conn = this.facade.getConnection();
        ArrayList<ArgInfo> argInfos = new ArrayList<ArgInfo>();
        sql = SQLHandler.guessArgs(runnerContext, sql, argInfos);
        try {
            PreparedStatement ps;
            CallableStatement cs;
            this.prepareInArgsValues(conn, runnerContext, argInfos);
            boolean outParam = false;
            for (ArgInfo argInfo : argInfos) {
                outParam = outParam || argInfo.isOut();
            }
            if (outParam) {
                if (this.batchCS == null && this.batchPS != null) {
                    throw new RuntimeException("Cannot mix PreparedStatement and CallableStatement in  a batch");
                }
                if (this.batchCS != null) {
                    cs = this.batchCS;
                    ps = cs;
                    this.checkSqlAndAddBatch(sql, ps);
                } else {
                    cs = conn.prepareCall(sql);
                    ps = cs;
                }
            } else if (this.batchPS != null) {
                ps = this.batchPS;
                cs = this.batchCS;
                this.checkSqlAndAddBatch(sql, ps);
            } else {
                ps = conn.prepareStatement(sql);
                cs = null;
            }
            for (int i = 0; i < argInfos.size(); ++i) {
                String typeName;
                ArgInfo argInfo = (ArgInfo)argInfos.get(i);
                Integer sqlType = argInfo.findOutSqlType();
                if (argInfo.isIn()) {
                    Object value = argInfo.getValue();
                    AbstractConverter converter = argInfo.getConverter();
                    if (value == null) {
                        if (sqlType == null) {
                            ps.setObject(i + 1, null);
                        } else if (converter != null && converter.getCustomSQLTypeName() != null) {
                            ps.setNull(i + 1, sqlType, converter.getCustomSQLTypeName());
                        } else {
                            ps.setNull(i + 1, sqlType);
                        }
                    } else if (value instanceof ByteArrayInputStream) {
                        int bytes = ((ByteArrayInputStream)value).available();
                        System.out.println("sql = " + sql);
                        System.out.println("bytes = " + bytes);
                        ps.setBinaryStream(i + 1, (InputStream)((ByteArrayInputStream)value), bytes);
                    } else if (value instanceof InputStream) {
                        System.out.println("IS sql = " + sql);
                        System.out.println("IS bytes = " + ((InputStream)value).available());
                        ps.setBinaryStream(i + 1, (InputStream)value);
                    } else if (sqlType != null) {
                        ps.setObject(i + 1, value, sqlType);
                    } else {
                        ps.setObject(i + 1, value);
                    }
                }
                if (!argInfo.isOut() || cs == null) continue;
                if (sqlType == null) {
                    sqlType = 12;
                }
                if ((typeName = argInfo.findOutSqlTypeName()) != null) {
                    cs.registerOutParameter(i + 1, (int)sqlType, typeName);
                    continue;
                }
                cs.registerOutParameter(i + 1, (int)sqlType);
            }
            if (this.facade.getQueryTimeout() != null) {
                ps.setQueryTimeout(this.facade.getQueryTimeout());
            }
            ps.setFetchSize(this.facade.getFetchSize());
            if (this.facade.getMaxRows() != null) {
                ps.setMaxRows(this.facade.getMaxRows());
            }
            if (addBatch) {
                this.batchPS = ps;
                this.batchCS = cs;
                this.batchArgInfos = argInfos;
                this.batchSQL = sql;
            } else {
                this.preparedStatementExecute(resultSetName, runnerContext, rowHandler, argInfos, ps, cs);
                this.batchCS = null;
                this.batchPS = null;
            }
        }
        catch (SQLException e) {
            throw new SQLException("SQL:" + sql + " \n" + e.toString(), e);
        }
    }

    private void checkSqlAndAddBatch(String sql, PreparedStatement ps) throws SQLException {
        if (!sql.replaceAll("\\s", "").equalsIgnoreCase(this.batchSQL.replaceAll("\\s", ""))) {
            throw new RuntimeException("SQL statement: \n" + sql + "\n does not match to the initial one on a batch:\n" + this.batchSQL);
        }
        ps.addBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preparedStatementExecute(String resultSetName, RunnerContext runnerContext, JSObject rowHandler, List<ArgInfo> argInfos, PreparedStatement ps, CallableStatement cs) throws SQLException, IOException {
        boolean resultsAvailable;
        try {
            AutoStopQuery.getInstance().register(runnerContext, ps);
            resultsAvailable = ps.execute();
        }
        finally {
            AutoStopQuery.getInstance().unregister(runnerContext, ps);
        }
        this.loadResultSets(resultSetName, runnerContext, ps, resultsAvailable, rowHandler);
        if (cs != null) {
            this.loadOutData(argInfos, runnerContext, cs, rowHandler);
        }
    }

    private void loadResultSets(String resultSetName, RunnerContext runnerContext, PreparedStatement ps, boolean resultsAvailable, JSObject rowHandler) throws SQLException, IOException {
        ArrayList<Integer> updateCount = new ArrayList<Integer>();
        while (true) {
            if (!resultsAvailable) {
                int uc = ps.getUpdateCount();
                if (uc == -1) break;
                updateCount.add(uc);
            } else {
                ResultSet rs = ps.getResultSet();
                this.loadResultSet(runnerContext, this.makeUniqueResultSetName(runnerContext, resultSetName), rs, rowHandler);
            }
            resultsAvailable = ps.getMoreResults();
        }
        this.facade.setUpdateCount(updateCount);
    }

    private String makeUniqueResultSetName(RunnerContext runnerContext, String resultSetName) {
        if (resultSetName == null || Utils.isBlank(resultSetName)) {
            resultSetName = "resultSet";
        }
        Set<String> usedNames = runnerContext.getUsedResultSetNames();
        String newResultSetName = resultSetName;
        int counter = 2;
        while (usedNames.contains(newResultSetName)) {
            newResultSetName = resultSetName + counter;
            ++counter;
        }
        usedNames.add(newResultSetName);
        return newResultSetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResultSet(RunnerContext runnerContext, String rsName, ResultSet rs, JSObject rowHandler) throws SQLException, IOException {
        ResponseStream resp = runnerContext.getResponseStream();
        resp.writePropertyArrayStart(rsName);
        rs.setFetchSize(this.facade.getFetchSize());
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            int cnt = metaData.getColumnCount();
            String[] cols = new String[cnt];
            String[] outNames = new String[cnt];
            AbstractConverter[] convertors = new AbstractConverter[cnt];
            for (int i = 0; i < cols.length; ++i) {
                String label;
                cols[i] = label = metaData.getColumnLabel(i + 1);
                if (label.startsWith("(")) {
                    ArgInfo argInfo = new ArgInfo(label);
                    SQLHandler.applyDirectivesToArgInfo(runnerContext, argInfo);
                    convertors[i] = argInfo.getConverter();
                    outNames[i] = label.substring(label.lastIndexOf(")") + 1);
                    continue;
                }
                outNames[i] = label;
            }
            JSObject line = rowHandler == null ? null : runnerContext.newJSObject();
            int index = 0;
            while (rs.next()) {
                Object value;
                if (rowHandler != null) {
                    for (int i = 0; i < cols.length; ++i) {
                        value = convertors[i] != null ? convertors[i].readFromResultSet(rs, i + 1, runnerContext, cols[i]) : rs.getObject(i + 1);
                        line.setMember(outNames[i], value);
                    }
                    Cloneable res = rowHandler.call((Object)rowHandler, new Object[]{line, index, rsName});
                    if (res instanceof Map) {
                        res = new LinkedHashMap(res);
                    } else if (res instanceof List) {
                        res = new ArrayList((List)((Object)res));
                    }
                    resp.writeFullObjectToArray(SQLHandler.genericConvertFromJdbc(runnerContext, res));
                } else {
                    resp.writeObjectStart();
                    for (int i = 0; i < cols.length; ++i) {
                        value = convertors[i] != null ? convertors[i].readFromResultSet(rs, i + 1, runnerContext, cols[i]) : rs.getObject(i + 1);
                        resp.writeProperty(outNames[i], SQLHandler.genericConvertFromJdbc(runnerContext, value));
                    }
                    resp.writeObjectEnd();
                }
                ++index;
            }
        }
        finally {
            resp.writePropertyArrayEnd();
            rs.close();
        }
    }

    protected void loadOutData(List<ArgInfo> args, RunnerContext runnerContext, CallableStatement cs, JSObject rowHandler) throws SQLException, IOException {
        int pos = 0;
        for (ArgInfo arg : args) {
            ++pos;
            if (!arg.isOut()) continue;
            Object value = cs.getObject(pos);
            String name = arg.getName();
            if (name.contains(")")) {
                name = name.substring(name.lastIndexOf(41) + 1);
            }
            if (name.startsWith("p.")) {
                name = name.substring(2);
            }
            if ((value = arg.getConverter() != null ? arg.getConverter().readFromCallableStatement(cs, pos, runnerContext, name) : SQLHandler.genericConvertFromJdbc(runnerContext, value)) instanceof ResultSet) {
                ResultSet rs = (ResultSet)value;
                this.loadResultSet(runnerContext, name, rs, rowHandler);
                continue;
            }
            runnerContext.getResponseStream().writeProperty(name, value);
        }
    }

    protected Map<String, Object> processMap(RunnerContext runnerContext, Map<String, Object> map) throws SQLException {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            entry.setValue(SQLHandler.genericConvertFromJdbc(runnerContext, entry.getValue()));
        }
        return map;
    }

    public static Object genericConvertFromJdbc(RunnerContext runnerContext, Object value) throws SQLException {
        if (value instanceof Array) {
            Object[] array = (Object[])((Array)value).getArray();
            for (int i = 0; i < array.length; ++i) {
                Object el = array[i];
                array[i] = SQLHandler.genericConvertFromJdbc(runnerContext, el);
            }
            value = array;
        } else if (value instanceof Struct) {
            Struct struct = (Struct)value;
            Object[] attributes = struct.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                Object el = attributes[i];
                attributes[i] = SQLHandler.genericConvertFromJdbc(runnerContext, el);
            }
            value = attributes;
        } else if (value instanceof Clob) {
            Clob clob = (Clob)value;
            value = clob.getCharacterStream();
        } else if (value instanceof Date && runnerContext != null) {
            value = runnerContext.getTypesFacade().dateToString((Date)value);
        }
        return value;
    }

    private void prepareInArgsValues(Connection connection, RunnerContext runnerContext, List<ArgInfo> argInfos) throws IOException, SQLException {
        for (ArgInfo argInfo : argInfos) {
            if (!argInfo.isIn()) continue;
            String name = argInfo.getName();
            Object value = null;
            try {
                value = runnerContext.getParam(name);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("for " + name + " value:" + value);
                }
            }
            catch (ScriptException e) {
                throw new IllegalArgumentException("Cannot evaluate the value of parameter:");
            }
            AbstractConverter convertor = argInfo.getConverter();
            if (convertor != null) {
                value = Utils.tryConvertToJavaCollections(value);
                Object newValue = convertor.convertToJdbc(connection, runnerContext, name, value);
                argInfo.setValue(newValue);
                continue;
            }
            argInfo.setValue(value);
        }
    }

    public static String guessArgs(RunnerContext runnerContext, String sql, List<ArgInfo> args) {
        ArrayList<String> usedArgs = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(sql);
        int pos = sb.indexOf(":");
        while (pos != -1) {
            if (pos != 0 && sb.charAt(pos - 1) != ':' && pos < sb.length() - 1 && ScriptTranslator.isBindingExpressionChar(sb.charAt(pos), sb.charAt(pos + 1), "")) {
                int pos2;
                for (pos2 = pos + 1; pos2 < sb.length() && ScriptTranslator.isBindingExpressionChar(sb.charAt(pos2 - 1), sb.charAt(pos2), sb.substring(pos, pos2)); ++pos2) {
                }
                String arg = sb.substring(pos + 1, pos2).trim();
                sb.replace(pos, pos2, "?");
                pos -= arg.length();
                usedArgs.add(arg);
            }
            pos = sb.indexOf(":", pos + 1);
        }
        sql = sb.toString().replaceAll("::", ":");
        for (String fullName : usedArgs) {
            ArgInfo argInfo = new ArgInfo(fullName);
            args.add(argInfo);
            SQLHandler.applyDirectivesToArgInfo(runnerContext, argInfo);
        }
        return sql;
    }

    public static void applyDirectivesToArgInfo(RunnerContext runnerContext, ArgInfo argInfo) {
        List<String> directives = SQLHandler.findDirectives(argInfo.getName());
        for (String directive : directives) {
            String directiveLower = directive.toLowerCase();
            if (directive.equalsIgnoreCase("inout")) {
                argInfo.setIn(true);
                argInfo.setOut(true);
                continue;
            }
            if (directive.equalsIgnoreCase("out")) {
                argInfo.setIn(false);
                argInfo.setOut(true);
                continue;
            }
            String[] parts = directive.split("\\.", 2);
            AbstractConverter converter = directiveLower.startsWith("blob") ? BlobConverter.getInstance() : (directiveLower.startsWith("array") ? ArrayConverter.getInstance() : (directiveLower.startsWith("json") ? JSONConverter.getInstance() : (directive.equalsIgnoreCase("number") || directive.equalsIgnoreCase("numeric") ? NumberConverter.getInstance() : (directive.equalsIgnoreCase("date") ? DateConverter.getInstance() : runnerContext.getTypesFacade().getCustomConverter(parts[0])))));
            if (converter != null && parts.length > 1) {
                converter.setConfig(parts[1]);
            }
            argInfo.setConverter(converter);
        }
        if (!argInfo.isOut()) {
            argInfo.setIn(true);
        }
    }

    private static List<String> findDirectives(String fullName) {
        ArrayList<String> directives = new ArrayList<String>();
        while (fullName.length() > 1 && fullName.charAt(0) == '(' && fullName.contains(")")) {
            int pos2 = fullName.indexOf(41);
            directives.add(fullName.substring(1, pos2));
            fullName = fullName.substring(pos2 + 1);
        }
        return directives;
    }
}

