/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.test;

import io.lightlink.core.ScriptRunner;
import io.lightlink.output.JSONStringBufferResponseStream;
import io.lightlink.test.TestRequest;
import io.lightlink.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.internal.runtime.ScriptObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightLinkFileTester {
    public static final Logger LOG = LoggerFactory.getLogger(LightLinkFileTester.class);
    String rootPackage;
    File file;
    int executionNumber;

    public LightLinkFileTester(String rootPackage, File file) {
        this.rootPackage = rootPackage;
        this.file = file;
    }

    public void doTestFile() throws IOException, ScriptException {
        String assertJs = null;
        String assertFileName = null;
        try {
            assertFileName = this.file.getAbsolutePath().replaceAll(".js.sql", ".asserts.js");
            if (assertFileName.contains("!")) {
                String cp = assertFileName.substring(assertFileName.indexOf(33) + 2).replace('\\', '/');
                assertJs = Utils.getResourceContent(cp);
            } else {
                assertJs = Utils.streamToString(new FileInputStream(assertFileName));
            }
        }
        catch (Exception e) {
            assertFileName = "default assert script: empty run'";
            assertJs = "run( {},function(res){})";
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        Bindings bindings = engine.getBindings(100);
        bindings.put("tester", (Object)this);
        bindings.put("_scriptName_", (Object)assertFileName);
        this.eval(engine, Utils.getResourceContent("io/lightlink/test/assertFunctions.js"));
        this.eval(engine, assertJs);
    }

    public String run(Object params) throws IOException, ScriptException {
        ++this.executionNumber;
        String[] parts = this.file.getAbsolutePath().replaceAll("\\\\", "/").split(this.rootPackage.replaceAll("\\.", "[\\\\/]") + "/");
        String actionName = parts[parts.length - 1].replaceAll(".js.sql", "");
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        if (params instanceof Map) {
            inputParams.putAll((Map)params);
        } else if (params instanceof ScriptObject) {
            ScriptObject so = (ScriptObject)params;
            Iterator iterator = so.propertyIterator();
            while (iterator.hasNext()) {
                String property = (String)iterator.next();
                inputParams.put(property, so.get((Object)property));
            }
        }
        JSONStringBufferResponseStream bufferResponseStream = new JSONStringBufferResponseStream();
        ScriptRunner scriptRunner = new ScriptRunner(this.rootPackage);
        scriptRunner.setRequest(TestRequest.getInstance());
        scriptRunner.execute(actionName, "TEST", inputParams, bufferResponseStream);
        String resJson = bufferResponseStream.getBuffer();
        if (this.file.exists()) {
            String fName = this.file.getAbsolutePath() + ".result" + this.executionNumber + ".json";
            FileOutputStream fos = new FileOutputStream(fName);
            fos.write(resJson.getBytes("UTF-8"));
            fos.close();
            LOG.info("Resulting JSON is saved for debugging purpose in " + fName);
        }
        return resJson;
    }

    private Object eval(ScriptEngine engine, String script) throws ScriptException {
        return engine.eval(script);
    }
}

