/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.test;

import io.lightlink.test.LightLinkFileTester;
import io.lightlink.utils.ClasspathScanUtils;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class LightLinkTestRunner
extends Runner {
    private Class testClass;
    private final List<File> fileList;
    private String rootPackage;

    public LightLinkTestRunner(Class<?> testClass) throws InitializationError, IOException {
        this.testClass = testClass;
        this.fileList = this.getFilesList(testClass);
    }

    public Class getTestClass() {
        return this.testClass;
    }

    public List<File> getFilesList(Class testClass) throws IOException {
        this.rootPackage = testClass.getPackage().getName();
        System.out.println("******************************");
        System.out.println("Test cases package = " + this.rootPackage);
        System.out.println("******************************");
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<String> resourcesFromPackage = ClasspathScanUtils.getAllResources(this.rootPackage, null);
        for (String resource : resourcesFromPackage) {
            if (!resource.matches("^.*\\.js\\.sql$") || resource.matches(".*[\\\\/]config\\.js\\.sql")) continue;
            fileList.add(ClasspathScanUtils.getFileFromResource(this.rootPackage, resource));
        }
        return fileList;
    }

    public Description getDescription() {
        return Description.createSuiteDescription((String)("LightLink unit tests : " + this.rootPackage).replaceAll("\\.", "[dot]"), (Annotation[])new Annotation[0]);
    }

    protected void doTestFile(File file) throws Exception {
        new LightLinkFileTester(this.rootPackage, file).doTestFile();
    }

    public void run(RunNotifier notifier) {
        String filePattern = System.getProperty("file");
        for (File file : this.fileList) {
            String fName = file.getName();
            if (filePattern == null || fName.matches(filePattern)) {
                System.out.println("Processing file : " + file);
                notifier.fireTestStarted(Description.createTestDescription((Class)this.testClass, (String)fName));
                try {
                    this.doTestFile(file);
                    notifier.fireTestFinished(Description.createTestDescription((Class)this.testClass, (String)fName));
                }
                catch (AssertionFailedError e) {
                    notifier.fireTestFailure(new Failure(Description.createTestDescription((Class)this.testClass, (String)fName), (Throwable)e));
                }
                catch (Throwable t) {
                    notifier.fireTestFailure(new Failure(Description.createTestDescription((Class)this.testClass, (String)fName), t));
                }
                continue;
            }
            System.out.println("Skipping file : " + file);
            notifier.fireTestIgnored(Description.createTestDescription((Class)this.testClass, (String)fName));
        }
    }

    public int testCount() {
        return this.fileList.size();
    }
}

