/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.types;

import io.lightlink.core.RunnerContext;
import io.lightlink.types.AbstractConverter;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ArrayConverter
extends AbstractConverter {
    private String type;

    public static AbstractConverter getInstance() {
        return new ArrayConverter();
    }

    @Override
    public void setConfig(String config) {
        this.type = config;
    }

    @Override
    public Object convertToJdbc(Connection connection, RunnerContext runnerContext, String name, Object value) throws IOException, SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            value = ((List)value).toArray();
        } else if (value instanceof String) {
            Object[] objectArray;
            if (StringUtils.isBlank((String)((String)value))) {
                objectArray = new Object[]{};
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            }
            value = objectArray;
        } else if (value instanceof Number) {
            value = new Object[]{value};
        }
        return connection.createArrayOf(this.type, value);
    }

    @Override
    public Object readFromResultSet(ResultSet resultSet, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        return resultSet.getArray(pos).getArray();
    }

    @Override
    public Object readFromCallableStatement(CallableStatement cs, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        return cs.getArray(pos).getArray();
    }

    @Override
    public Integer getSQLType() {
        return 2003;
    }
}

