/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.types;

import io.lightlink.core.RunnerContext;
import io.lightlink.types.AbstractConverter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class BlobConverter
extends AbstractConverter {
    private String encoding;

    public static AbstractConverter getInstance() {
        return new BlobConverter();
    }

    @Override
    public void setConfig(String config) {
        this.encoding = config;
    }

    @Override
    public Object convertToJdbc(Connection connection, RunnerContext runnerContext, String name, Object value) throws IOException {
        byte[] array;
        if (value == null) {
            return null;
        }
        if (value instanceof InputStream && StringUtils.isBlank((String)this.encoding)) {
            return value;
        }
        if (value instanceof byte[]) {
            array = (byte[])value;
        } else if (value instanceof InputStream) {
            array = IOUtils.toByteArray((InputStream)((InputStream)value));
        } else if (value instanceof String) {
            String str = (String)value;
            if (this.encoding.equalsIgnoreCase("base64")) {
                array = DatatypeConverter.parseBase64Binary((String)str);
            } else {
                try {
                    array = str.getBytes(this.encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Cannot convert value:" + value + " to Blob. Specified encoding:" + this.encoding + " not recognised. (note:default encoding for String is base64)");
                }
            }
        } else {
            throw new IllegalArgumentException("Cannot convert value:" + value + " of type:" + value.getClass().getName() + " to Blob. int[] or String expected. (note:default encoding for String is base64)");
        }
        return new ByteArrayInputStream(array);
    }

    @Override
    public Object readFromResultSet(ResultSet resultSet, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        InputStream stream = resultSet.getBinaryStream(pos);
        return this.inputStreamToReturnValue(stream);
    }

    @Override
    public Object readFromCallableStatement(CallableStatement cs, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        InputStream stream = cs.getBlob(pos).getBinaryStream();
        return this.inputStreamToReturnValue(stream);
    }

    private Object inputStreamToReturnValue(InputStream stream) throws IOException {
        if (this.encoding.equalsIgnoreCase("base64")) {
            String res = DatatypeConverter.printBase64Binary((byte[])IOUtils.toByteArray((InputStream)stream));
            stream.close();
            return res;
        }
        if (StringUtils.isNotBlank((String)this.encoding)) {
            String res = new String(IOUtils.toByteArray((InputStream)stream), this.encoding);
            stream.close();
            return res;
        }
        return stream;
    }

    @Override
    public Integer getSQLType() {
        return 2004;
    }
}

