/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.types;

import io.lightlink.core.RunnerContext;
import io.lightlink.facades.TypesFacade;
import io.lightlink.types.AbstractConverter;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class DateConverter
extends AbstractConverter {
    public static final String UNIVERSAL_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String[][] DATE_PATTERNS = new String[][]{{"^\\d\\d\\d\\d-\\d\\d-\\d\\dT\\d\\d:\\d\\d:\\d\\d.\\d\\d\\d.*$", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX"}, {"^\\d\\d\\d\\d-\\d\\d-\\d\\d$", "yyyy-MM-dd"}, {"^\\d\\d\\d\\d-\\d\\d-\\d\\d\\ \\d\\d:\\d\\d$", "yyyy-MM-dd HH:mm"}, {"^\\d\\d\\d\\d-\\d\\d-\\d\\d\\ \\d\\d:\\d\\d:\\d\\d$", "yyyy-MM-dd HH:mm:ss"}, {"^\\d\\d\\d\\d/\\d\\d/\\d\\d$", "yyyy/MM/dd"}, {"^\\d\\d\\d\\d/\\d\\d/\\d\\d\\ \\d\\d:\\d\\d$", "yyyy/MM/dd HH:mm"}, {"^\\d\\d\\d\\d/\\d\\d/\\d\\d\\ \\d\\d:\\d\\d:\\d\\d$", "yyyy/MM/dd HH:mm:ss"}, {"^\\d\\d\\d\\d\\d\\d\\d\\d$", "yyyyMMdd"}, {"^\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d$", "yyyyMMddHHmmss"}};
    public static final DateConverter instance = new DateConverter();

    public static DateConverter getInstance() {
        return instance;
    }

    @Override
    public Object convertToJdbc(Connection connection, RunnerContext runnerContext, String name, Object value) {
        if (value == null || value instanceof String && ((String)value).trim().length() == 0) {
            return null;
        }
        if (value instanceof ScriptObjectMirror && ((ScriptObjectMirror)value).getClassName().equals("Date")) {
            Number time = (Number)((ScriptObjectMirror)value).callMember("getTime", new Object[0]);
            return new java.sql.Date(time.longValue());
        }
        return this.tryToConvertToDate(runnerContext.getTypesFacade(), name, value);
    }

    protected Timestamp tryToConvertToDate(TypesFacade typesFacade, String name, Object v) {
        if (v instanceof Date) {
            return new Timestamp(((Date)v).getTime());
        }
        if (v instanceof Number) {
            return new Timestamp(((Number)v).longValue());
        }
        String vStr = v.toString();
        String customPattern = typesFacade.getCustomDatePattern();
        if (customPattern != null) {
            try {
                return new Timestamp(new SimpleDateFormat(customPattern).parse(vStr).getTime());
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        Timestamp d = null;
        try {
            for (String[] pattern : DATE_PATTERNS) {
                if (!vStr.matches(pattern[0])) continue;
                d = new Timestamp(new SimpleDateFormat(pattern[1]).parse(vStr).getTime());
                break;
            }
        }
        catch (ParseException e) {
            // empty catch block
        }
        if (d == null) {
            throw new IllegalArgumentException("Cannot parse as date the value:" + v + " field:" + name);
        }
        return d;
    }

    public Object convertFromJdbc(Object value) {
        if (value != null && value instanceof Date) {
            return new Date(((Date)value).getTime());
        }
        return value;
    }

    @Override
    public Object readFromResultSet(ResultSet resultSet, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        return this.convertFromJdbc(super.readFromResultSet(resultSet, pos, runnerContext, colName));
    }

    @Override
    public Object readFromCallableStatement(CallableStatement cs, int pos, RunnerContext runnerContext, String colName) throws SQLException, IOException {
        return this.convertFromJdbc(super.readFromCallableStatement(cs, pos, runnerContext, colName));
    }

    @Override
    public Integer getSQLType() {
        return 93;
    }
}

