/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;

public class ClasspathScanUtils {
    public static ArrayList<String> getAllResources(String packageName, ServletContext servletContext) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(ClasspathScanUtils.getResourcesFromPackage(packageName));
        res.addAll(ClasspathScanUtils.getResourcesFromWebInf(packageName, servletContext));
        return res;
    }

    private static List<String> getResourcesFromWebInf(String packageName, ServletContext servletContext) {
        if (servletContext == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> res = new ArrayList<String>();
        ClasspathScanUtils.findFromServletContext(servletContext, "/WEB-INF/" + packageName.replace('.', '/') + "/", "", res);
        return res;
    }

    public static List<String> getResourcesFromPackage(String packageName) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> names = new ArrayList<String>();
        packageName = packageName.replace(".", "/");
        Enumeration<URL> packageURLs = classLoader.getResources(packageName);
        while (packageURLs.hasMoreElements()) {
            URL packageURL = packageURLs.nextElement();
            if (packageURL.getProtocol().equals("jar")) {
                String jarFileName = URLDecoder.decode(packageURL.getFile(), "UTF-8");
                jarFileName = jarFileName.substring(5, jarFileName.indexOf("!"));
                JarFile jf = new JarFile(jarFileName);
                Enumeration<JarEntry> jarEntries = jf.entries();
                while (jarEntries.hasMoreElements()) {
                    String entryName = jarEntries.nextElement().getName();
                    if (!entryName.startsWith(packageName) || entryName.length() <= packageName.length() + 5) continue;
                    entryName = entryName.substring(packageName.length());
                    names.add(entryName);
                }
                continue;
            }
            ClasspathScanUtils.findFromDirectory(packageURL, names);
        }
        return names;
    }

    private static void findFromServletContext(ServletContext servletContext, String initialPath, String currentPath, List<String> res) {
        String totalPath = initialPath + currentPath;
        if (totalPath.endsWith("/")) {
            Set paths = servletContext.getResourcePaths(totalPath);
            for (String p : paths) {
                ClasspathScanUtils.findFromServletContext(servletContext, initialPath, p.substring(initialPath.length()), res);
            }
        } else {
            res.add(currentPath);
        }
    }

    private static void findFromDirectory(URL packageURL, List<String> names) throws UnsupportedEncodingException {
        if (packageURL == null) {
            return;
        }
        File folder = new File(URLDecoder.decode(packageURL.getPath(), "UTF-8"));
        Collection files = FileUtils.listFiles((File)folder, null, (boolean)true);
        int length = folder.getAbsolutePath().length();
        if (files != null) {
            for (File actual : files) {
                String entryName = actual.getAbsolutePath().substring(length);
                names.add(entryName);
            }
        }
    }

    public static File getFileFromResource(String rootPackage, String resource) {
        String resourceName;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(resourceName = rootPackage.replace('.', '/') + resource);
        if (url == null) {
            throw new IllegalArgumentException("Cannot find :" + resourceName + "   " + resource);
        }
        return new File(URLDecoder.decode(url.getPath()));
    }
}

