/*
 * Decompiled with CFR 0.152.
 */
package io.lightlink.utils;

import io.lightlink.config.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.servlet.ServletContext;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import jdk.nashorn.internal.runtime.ScriptObject;

public class Utils {
    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String streamToString(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = is.read(buffer))) {
            sb.append(new String(buffer, 0, n));
        }
        return sb.toString();
    }

    public static String getResourceContent(String resource) throws IOException {
        InputStream fnStream = ConfigManager.isInDebugMode() ? Thread.currentThread().getContextClassLoader().getResource(resource).openStream() : Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        String assertFns = Utils.streamToString(fnStream);
        fnStream.close();
        return assertFns;
    }

    public static Object tryConvertToJavaCollections(Object value) {
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        } else {
            if (value instanceof int[]) {
                ArrayList<Integer> res = new ArrayList<Integer>();
                for (int i = 0; i < ((int[])value).length; ++i) {
                    res.add(((int[])value)[i]);
                }
                return res;
            }
            if (value instanceof double[]) {
                ArrayList<Double> res = new ArrayList<Double>();
                for (int i = 0; i < ((double[])value).length; ++i) {
                    res.add(((double[])value)[i]);
                }
                return res;
            }
            if (value instanceof float[]) {
                ArrayList<Float> res = new ArrayList<Float>();
                for (int i = 0; i < ((float[])value).length; ++i) {
                    res.add(Float.valueOf(((float[])value)[i]));
                }
                return res;
            }
            if (value instanceof ScriptObjectMirror && "Date".equalsIgnoreCase(((ScriptObjectMirror)value).getClassName())) {
                Double time = (Double)((ScriptObjectMirror)value).callMember("getTime", new Object[0]);
                return new Date(time.longValue());
            }
            if (value instanceof ScriptObject) {
                ScriptObject scriptObject = (ScriptObject)value;
                if (scriptObject.isArray()) {
                    String[] ownKeys = scriptObject.getOwnKeys(false);
                    ArrayList<Object> res = new ArrayList<Object>();
                    for (String key : ownKeys) {
                        Object propertyValue = scriptObject.get((Object)key);
                        propertyValue = Utils.tryConvertToJavaCollections(propertyValue);
                        res.add(propertyValue);
                    }
                    return res;
                }
                String[] ownKeys = scriptObject.getOwnKeys(true);
                LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
                for (String key : ownKeys) {
                    Object propertyValue = scriptObject.get((Object)key);
                    propertyValue = Utils.tryConvertToJavaCollections(propertyValue);
                    res.put(key, propertyValue);
                }
                return res;
            }
            if (value instanceof ScriptObjectMirror) {
                ScriptObjectMirror ScriptObjectMirror2 = (ScriptObjectMirror)value;
                if (ScriptObjectMirror2.isArray()) {
                    String[] ownKeys = ScriptObjectMirror2.getOwnKeys(false);
                    ArrayList<Object> res = new ArrayList<Object>();
                    for (String key : ownKeys) {
                        Object propertyValue = ScriptObjectMirror2.get((Object)key);
                        propertyValue = Utils.tryConvertToJavaCollections(propertyValue);
                        res.add(propertyValue);
                    }
                    return res;
                }
                String[] ownKeys = ScriptObjectMirror2.getOwnKeys(true);
                LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
                for (String key : ownKeys) {
                    Object propertyValue = ScriptObjectMirror2.get((Object)key);
                    propertyValue = Utils.tryConvertToJavaCollections(propertyValue);
                    res.put(key, propertyValue);
                }
                return res;
            }
        }
        return value;
    }

    public static boolean isFirstNonAlphabetic(String name) {
        String[] parts;
        for (String part : parts = name.split("[\\./]")) {
            char c1;
            if (part.length() == 0 || Character.isAlphabetic(c1 = part.charAt(0))) continue;
            return true;
        }
        return false;
    }

    public static URL getUrl(String name, ServletContext servletContext) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null && servletContext != null) {
            url = Utils.getUrlFromServletContext("/WEB-INF/" + name, servletContext);
        }
        if (url == null && servletContext != null) {
            url = Utils.getUrlFromServletContext("/" + name, servletContext);
        }
        if (url == null) {
            return null;
        }
        return url;
    }

    private static URL getUrlFromServletContext(String name, ServletContext servletContext) {
        try {
            URL resource = servletContext.getResource(name);
            if (resource != null) {
                String realPath = servletContext.getRealPath(name);
                resource = new File(realPath).toURI().toURL();
            }
            return resource;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

