package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.box.out.BoxIn;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BoxOutBuilder} instances.
 *
 * @see BoxOutBuilder
 *
 */
public class BoxOutBuilder implements Builder<BoxOut> {

    private BoxIn _boxIn;


    Map<Class<? extends Augmentation<BoxOut>>, Augmentation<BoxOut>> augmentation = Collections.emptyMap();

    public BoxOutBuilder() {
    }

    public BoxOutBuilder(BoxOut base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<BoxOut>>, Augmentation<BoxOut>> aug =((AugmentationHolder<BoxOut>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._boxIn = base.getBoxIn();
    }


    public BoxIn getBoxIn() {
        return _boxIn;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BoxOut>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public BoxOutBuilder setBoxIn(final BoxIn value) {
        this._boxIn = value;
        return this;
    }
    
    public BoxOutBuilder addAugmentation(Class<? extends Augmentation<BoxOut>> augmentationType, Augmentation<BoxOut> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public BoxOutBuilder removeAugmentation(Class<? extends Augmentation<BoxOut>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BoxOut build() {
        return new BoxOutImpl(this);
    }

    private static final class BoxOutImpl
        extends AbstractAugmentable<BoxOut>
        implements BoxOut {
    
        private final BoxIn _boxIn;
    
        BoxOutImpl(BoxOutBuilder base) {
            super(base.augmentation);
            this._boxIn = base.getBoxIn();
        }
    
        @Override
        public Class<BoxOut> getImplementedInterface() {
            return BoxOut.class;
        }
    
        @Override
        public BoxIn getBoxIn() {
            return _boxIn;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_boxIn);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BoxOut.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BoxOut other = (BoxOut)obj;
            if (!Objects.equals(_boxIn, other.getBoxIn())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                BoxOutImpl otherImpl = (BoxOutImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<BoxOut>>, Augmentation<BoxOut>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("BoxOut");
            CodeHelpers.appendValue(helper, "_boxIn", _boxIn);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
