package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>example-data-center</b>
 * <pre>
 * module example-data-center {
 *   yang-version 1.1;
 *   namespace urn:example:data-center;
 *   prefix sfarm;
 *   revision 2018-08-07;
 *   list server {
 *     key name;
 *     leaf name {
 *       type string;
 *     }
 *     action reset {
 *       input {
 *         leaf reset-at {
 *           type string;
 *         }
 *       }
 *       output {
 *         leaf reset-finished-at {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 *   container device {
 *     action start {
 *       input {
 *         leaf start-at {
 *           type string;
 *         }
 *       }
 *       output {
 *         leaf start-finished-at {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 *   container box-out {
 *     container box-in {
 *       action open {
 *         input;
 *         output;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
public interface ExampleDataCenterData
    extends
    DataRoot
{




    /**
     * @return <code>java.util.List</code> <code>server</code>, or <code>null</code> if not present
     */
    @Nullable List<Server> getServer();
    
    /**
     * @return <code>java.util.List</code> <code>server</code>, or an empty list if it is not present
     */
    default @NonNull List<Server> nonnullServer() {
        return CodeHelpers.nonnull(getServer());
    }
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.Device</code> <code>device</code>, or <code>null</code> if not present
     */
    @Nullable Device getDevice();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.BoxOut</code> <code>boxOut</code>, or <code>null</code> if not present
     */
    @Nullable BoxOut getBoxOut();

}

