package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.box.out;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BoxInBuilder} instances.
 *
 * @see BoxInBuilder
 *
 */
public class BoxInBuilder implements Builder<BoxIn> {



    Map<Class<? extends Augmentation<BoxIn>>, Augmentation<BoxIn>> augmentation = Collections.emptyMap();

    public BoxInBuilder() {
    }

    public BoxInBuilder(BoxIn base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<BoxIn>>, Augmentation<BoxIn>> aug =((AugmentationHolder<BoxIn>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }



    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BoxIn>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public BoxInBuilder addAugmentation(Class<? extends Augmentation<BoxIn>> augmentationType, Augmentation<BoxIn> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public BoxInBuilder removeAugmentation(Class<? extends Augmentation<BoxIn>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BoxIn build() {
        return new BoxInImpl(this);
    }

    private static final class BoxInImpl
        extends AbstractAugmentable<BoxIn>
        implements BoxIn {
    
    
        BoxInImpl(BoxInBuilder base) {
            super(base.augmentation);
        }
    
        @Override
        public Class<BoxIn> getImplementedInterface() {
            return BoxIn.class;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BoxIn.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BoxIn other = (BoxIn)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                BoxInImpl otherImpl = (BoxInImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<BoxIn>>, Augmentation<BoxIn>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("BoxIn");
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
