package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.device.start;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link OutputBuilder} instances.
 *
 * @see OutputBuilder
 *
 */
public class OutputBuilder implements Builder<Output> {

    private String _startFinishedAt;


    Map<Class<? extends Augmentation<Output>>, Augmentation<Output>> augmentation = Collections.emptyMap();

    public OutputBuilder() {
    }

    public OutputBuilder(Output base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Output>>, Augmentation<Output>> aug =((AugmentationHolder<Output>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._startFinishedAt = base.getStartFinishedAt();
    }


    public String getStartFinishedAt() {
        return _startFinishedAt;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Output>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public OutputBuilder setStartFinishedAt(final String value) {
        this._startFinishedAt = value;
        return this;
    }
    
    public OutputBuilder addAugmentation(Class<? extends Augmentation<Output>> augmentationType, Augmentation<Output> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public OutputBuilder removeAugmentation(Class<? extends Augmentation<Output>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Output build() {
        return new OutputImpl(this);
    }

    private static final class OutputImpl
        extends AbstractAugmentable<Output>
        implements Output {
    
        private final String _startFinishedAt;
    
        OutputImpl(OutputBuilder base) {
            super(base.augmentation);
            this._startFinishedAt = base.getStartFinishedAt();
        }
    
        @Override
        public Class<Output> getImplementedInterface() {
            return Output.class;
        }
    
        @Override
        public String getStartFinishedAt() {
            return _startFinishedAt;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_startFinishedAt);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Output.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Output other = (Output)obj;
            if (!Objects.equals(_startFinishedAt, other.getStartFinishedAt())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                OutputImpl otherImpl = (OutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Output>>, Augmentation<Output>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Output");
            CodeHelpers.appendValue(helper, "_startFinishedAt", _startFinishedAt);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
