package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.box.out.BoxIn;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>example-data-center</b>
 * <pre>
 * container box-out {
 *   container box-in {
 *     action open;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link BoxOutBuilder}.
 * @see BoxOutBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface BoxOut
    extends
    ChildOf<ExampleDataCenterData>,
    Augmentable<BoxOut>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("box-out");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.BoxOut> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.BoxOut.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.@NonNull BoxOut obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getBoxIn());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.@NonNull BoxOut thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.BoxOut.class, obj);
        return other != null
            && Objects.equals(thisObj.getBoxIn(), other.getBoxIn())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.@NonNull BoxOut obj) {
        final var helper = MoreObjects.toStringHelper("BoxOut");
        CodeHelpers.appendValue(helper, "boxIn", obj.getBoxIn());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return boxIn, or {@code null} if it is not present.
     *
     * @return {@code BoxIn} boxIn, or {@code null} if it is not present.
     *
     */
    BoxIn getBoxIn();
    
    /**
     * Return boxIn, or an empty instance if it is not present.
     *
     * @return {@code BoxIn} boxIn, or an empty instance if it is not present.
     *
     */
    @NonNull BoxIn nonnullBoxIn();

}

