package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.box.out.BoxIn;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link BoxOut} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     BoxOut createBoxOut(int fooXyzzy, int barBaz) {
 *         return new BoxOutBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of BoxOut, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see BoxOut
 *
 */
@Generated("mdsal-binding-generator")
public class BoxOutBuilder {

    private BoxIn _boxIn;


    Map<Class<? extends Augmentation<BoxOut>>, Augmentation<BoxOut>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public BoxOutBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link BoxOut}.
     *
     * @param base BoxOut from which the builder should be initialized
     */
    public BoxOutBuilder(BoxOut base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._boxIn = base.getBoxIn();
    }


    private static final class LazyEmpty {
        static final @NonNull BoxOut INSTANCE = new BoxOutBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of BoxOut.
     *
     * @return An empty {@link BoxOut}
     */
    public static @NonNull BoxOut empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link BoxOut#getBoxIn()}.
     *
     * @return current value
     */
    public BoxIn getBoxIn() {
        return _boxIn;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BoxOut>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link BoxOut#getBoxIn()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public BoxOutBuilder setBoxIn(final BoxIn value) {
        this._boxIn = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public BoxOutBuilder addAugmentation(Augmentation<BoxOut> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public BoxOutBuilder removeAugmentation(Class<? extends Augmentation<BoxOut>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link BoxOut} instance.
     *
     * @return A new {@link BoxOut} instance.
     */
    public @NonNull BoxOut build() {
        return new BoxOutImpl(this);
    }

    private static final class BoxOutImpl
        extends AbstractAugmentable<BoxOut>
        implements BoxOut {
    
        private final BoxIn _boxIn;
    
        BoxOutImpl(BoxOutBuilder base) {
            super(base.augmentation);
            this._boxIn = base.getBoxIn();
        }
    
        @Override
        public BoxIn getBoxIn() {
            return _boxIn;
        }
    
        @Override
        public BoxIn nonnullBoxIn() {
            return Objects.requireNonNullElse(getBoxIn(), org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.box.out.BoxInBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = BoxOut.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return BoxOut.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return BoxOut.bindingToString(this);
        }
    }
}
