package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * Example of yang model for data center Copyright (c) 2021 PANTHEON.tech s.r.o. 
 * All Rights Reserved. This program and the accompanying materials are made 
 * available under the terms of the Eclipse Public License v1.0 which accompanies 
 * this distribution, and is available at 
 * https://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>example-data-center</b>
 * <pre>
 * module example-data-center {
 *   yang-version 1.1;
 *   namespace urn:example:data-center;
 *   prefix sfarm;
 *   revision 2018-08-07;
 *   list server {
 *     key name;
 *     leaf name {
 *       type string;
 *     }
 *     action reset {
 *       input input {
 *         leaf reset-at {
 *           type string;
 *         }
 *       }
 *       output output {
 *         leaf reset-finished-at {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 *   container device {
 *     action start {
 *       input input {
 *         leaf start-at {
 *           type string;
 *         }
 *       }
 *       output output {
 *         leaf start-finished-at {
 *           type string;
 *         }
 *       }
 *     }
 *   }
 *   container box-out {
 *     container box-in {
 *       action open;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ExampleDataCenterData
    extends
    DataRoot
{




    /**
     * Return server, or {@code null} if it is not present.
     *
     * @return {@code Map<ServerKey, Server>} server, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ServerKey, Server> getServer();
    
    /**
     * Return server, or an empty list if it is not present.
     *
     * @return {@code Map<ServerKey, Server>} server, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ServerKey, Server> nonnullServer() {
        return CodeHelpers.nonnull(getServer());
    }
    
    /**
     * Return device, or {@code null} if it is not present.
     *
     * @return {@code Device} device, or {@code null} if it is not present.
     *
     */
    Device getDevice();
    
    /**
     * Return device, or an empty instance if it is not present.
     *
     * @return {@code Device} device, or an empty instance if it is not present.
     *
     */
    @NonNull Device nonnullDevice();
    
    /**
     * Return boxOut, or {@code null} if it is not present.
     *
     * @return {@code BoxOut} boxOut, or {@code null} if it is not present.
     *
     */
    BoxOut getBoxOut();
    
    /**
     * Return boxOut, or an empty instance if it is not present.
     *
     * @return {@code BoxOut} boxOut, or an empty instance if it is not present.
     *
     */
    @NonNull BoxOut nonnullBoxOut();

}

