package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifier;

/**
 * This class represents the key of {@link Server} class.
 *
 * @see Server
 *
 */
@Generated("mdsal-binding-generator")
public class ServerKey
 implements Identifier<Server> {
    @java.io.Serial
    private static final long serialVersionUID = -7421388650032685410L;
    private final String _name;


    /**
     * Constructs an instance.
     *
     * @param _name the entity name
     * @throws NullPointerException if any of the arguments are null
     */
    public ServerKey(@NonNull String _name) {
        this._name = CodeHelpers.requireKeyProp(_name, "name");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public ServerKey(ServerKey source) {
        this._name = source._name;
    }


    /**
     * Return name, guaranteed to be non-null.
     *
     * @return {@code String} name, guaranteed to be non-null.
     */
    public @NonNull String getName() {
        return _name;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_name);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof ServerKey other
            && Objects.equals(_name, other._name);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(ServerKey.class);
        CodeHelpers.appendValue(helper, "name", _name);
        return helper.toString();
    }
}

