package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.server;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.$YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>example-data-center</b>
 * <pre>
 * input input {
 *   leaf reset-at {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface ResetInput
    extends
    RpcInput,
    Augmentable<ResetInput>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.server.ResetInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.server.ResetInput.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.server.@NonNull ResetInput obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getResetAt());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.server.@NonNull ResetInput thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.server.ResetInput.class, obj);
        return other != null
            && Objects.equals(thisObj.getResetAt(), other.getResetAt())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.server.@NonNull ResetInput obj) {
        final var helper = MoreObjects.toStringHelper("ResetInput");
        CodeHelpers.appendValue(helper, "resetAt", obj.getResetAt());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return resetAt, or {@code null} if it is not present.
     *
     * @return {@code String} resetAt, or {@code null} if it is not present.
     *
     */
    String getResetAt();
    
    /**
     * Return resetAt, guaranteed to be non-null.
     *
     * @return {@code String} resetAt, guaranteed to be non-null.
     * @throws NoSuchElementException if resetAt is not present
     *
     */
    default @NonNull String requireResetAt() {
        return CodeHelpers.require(getResetAt(), "resetat");
    }

}

