package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807;
import javax.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.box.out.BoxIn;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>example-data-center</b>
 * <pre>
 * container box-out {
 *   container box-in {
 *     action open {
 *       input;
 *       output;
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>example-data-center/box-out</i>
 *
 * <p>To create instances of this class use {@link BoxOutBuilder}.
 * @see BoxOutBuilder
 *
 */
public interface BoxOut
    extends
    ChildOf<ExampleDataCenterData>,
    Augmentable<BoxOut>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("box-out");

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.box.out.BoxIn</code> <code>boxIn</code>, or <code>null</code> if not present
     */
    @Nullable
    BoxIn getBoxIn();

}

