package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807;
import java.lang.Override;
import java.lang.String;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>example-data-center</b>
 * <pre>
 * list server {
 *   key name;
 *   leaf name {
 *     type string;
 *   }
 *   action reset {
 *     input {
 *       leaf reset-at {
 *         type string;
 *       }
 *     }
 *     output {
 *       leaf reset-finished-at {
 *         type string;
 *       }
 *     }
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>example-data-center/server</i>
 *
 * <p>To create instances of this class use {@link ServerBuilder}.
 * @see ServerBuilder
 * @see ServerKey
 *
 */
public interface Server
    extends
    ChildOf<ExampleDataCenterData>,
    Augmentable<Server>,
    Identifiable<ServerKey>
{



    public static final QName QNAME = $YangModuleInfoImpl.qnameOf("server");

    /**
     * @return <code>java.lang.String</code> <code>name</code>, or <code>null</code> if not present
     */
    @Nullable
    String getName();
    
    @Override
    ServerKey key();

}

