package org.opendaylight.yang.gen.v1.urn.example.data.center.rev180807.device.start;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link InputBuilder} instances.
 *
 * @see InputBuilder
 *
 */
public class InputBuilder implements Builder<Input> {

    private String _startAt;


    Map<Class<? extends Augmentation<Input>>, Augmentation<Input>> augmentation = Collections.emptyMap();

    public InputBuilder() {
    }

    public InputBuilder(Input base) {
        this._startAt = base.getStartAt();
        if (base instanceof InputImpl) {
            InputImpl impl = (InputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<Input>>, Augmentation<Input>> aug =((AugmentationHolder<Input>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public String getStartAt() {
        return _startAt;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Input>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public InputBuilder setStartAt(final String value) {
        this._startAt = value;
        return this;
    }
    
    public InputBuilder addAugmentation(Class<? extends Augmentation<Input>> augmentationType, Augmentation<Input> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public InputBuilder removeAugmentation(Class<? extends Augmentation<Input>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Input build() {
        return new InputImpl(this);
    }

    private static final class InputImpl implements Input {
    
        private final String _startAt;
    
        private Map<Class<? extends Augmentation<Input>>, Augmentation<Input>> augmentation = Collections.emptyMap();
    
        InputImpl(InputBuilder base) {
            this._startAt = base.getStartAt();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<Input> getImplementedInterface() {
            return Input.class;
        }
    
        @Override
        public String getStartAt() {
            return _startAt;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<Input>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_startAt);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Input.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Input other = (Input)obj;
            if (!Objects.equals(_startAt, other.getStartAt())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                InputImpl otherImpl = (InputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<Input>>, Augmentation<Input>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Input");
            CodeHelpers.appendValue(helper, "_startAt", _startAt);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
