/*
 * Decompiled with CFR 0.152.
 */
package io.logspace.agent.api;

import io.logspace.agent.api.Agent;
import io.logspace.agent.api.AgentController;
import io.logspace.agent.api.AgentControllerException;
import io.logspace.agent.api.AgentControllerProvider;
import io.logspace.agent.api.event.Event;
import io.logspace.agent.api.event.EventBuilderData;
import io.logspace.agent.api.order.AgentCapabilities;
import io.logspace.agent.api.order.TriggerType;

abstract class AbstractAgent
implements Agent {
    private final String id;
    private final String type;
    private AgentCapabilities capabilities;
    private AgentController agentController;

    protected AbstractAgent(String id, String type, TriggerType[] triggerTypes) {
        this.id = id;
        this.type = type;
        this.updateCapabilities(triggerTypes);
        this.setAgentController(AgentControllerProvider.getAgentController());
    }

    @Override
    public final AgentCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getType() {
        return this.type;
    }

    protected final AgentController getAgentController() {
        return this.agentController;
    }

    protected EventBuilderData getEventBuilderData() {
        return new EventBuilderData(this.getId(), this.agentController.getSystem(), this.agentController.getMarker());
    }

    protected final boolean isEnabled() {
        return this.agentController != null && this.agentController.isAgentEnabled(this.id);
    }

    protected final void sendEvent(Event event) {
        if (this.agentController == null) {
            throw new AgentControllerException("This Agent has no AgentController.");
        }
        this.agentController.send(event);
    }

    protected final void updateCapabilities(TriggerType[] triggerTypes) {
        AgentCapabilities agentCapabilities = new AgentCapabilities();
        agentCapabilities.setId(this.getId());
        agentCapabilities.setType(this.getType());
        agentCapabilities.setSupportedTriggerTypes(triggerTypes);
        this.capabilities = agentCapabilities;
    }

    private void setAgentController(AgentController agentController) {
        if (this.agentController != null) {
            this.agentController.unregister(this);
        }
        this.agentController = agentController;
        if (this.agentController != null) {
            this.agentController.register(this);
        }
    }
}

