/*
 * Decompiled with CFR 0.152.
 */
package io.logspace.agent.api;

import io.logspace.agent.api.AgentControllerDescription;
import io.logspace.agent.api.AgentControllerDescriptionDeserializer;
import io.logspace.agent.api.AgentControllerInitializationException;
import java.io.IOException;
import java.io.InputStream;

public final class AgentControllerDescriptionFactory {
    private static final String IMPLEMENTATION_PROPERTY_NAME = "logspace.config-deserializer";
    private static final String DEFAULT_IMPLEMENTATION = "io.logspace.agent.api.json.AgentControllerDescriptionJsonDeserializer";

    private AgentControllerDescriptionFactory() {
    }

    public static AgentControllerDescription fromJson(InputStream inputStream) throws IOException {
        AgentControllerDescriptionDeserializer deserializer = AgentControllerDescriptionFactory.getDeserializer();
        return deserializer.read(inputStream);
    }

    public static AgentControllerDescriptionDeserializer getDeserializer() {
        String deserializerClassName = System.getProperty(IMPLEMENTATION_PROPERTY_NAME, DEFAULT_IMPLEMENTATION);
        try {
            Class<?> deserializerClass = Class.forName(deserializerClassName);
            return (AgentControllerDescriptionDeserializer)deserializerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            if (DEFAULT_IMPLEMENTATION.equals(deserializerClassName)) {
                throw new AgentControllerInitializationException("Could not load class '" + deserializerClassName + "' as deserializer for the logspace configuration. Is logspace-agent-json.jar part of the classpath?", e);
            }
            throw new AgentControllerInitializationException("Could not find class '" + deserializerClassName + "' as deserializer for the logspace configuration. Did you configure '" + IMPLEMENTATION_PROPERTY_NAME + "' properly?", e);
        }
        catch (InstantiationException e) {
            throw new AgentControllerInitializationException("Could not instantiate class '" + deserializerClassName + "' as deserializer for the logspace configuration. Does this class have a default constructor?", e);
        }
        catch (IllegalAccessException e) {
            throw new AgentControllerInitializationException("Could not access the constructor of class '" + deserializerClassName + "' as deserializer for the logspace configuration. Does this class have a default constructor?", e);
        }
    }
}

