/*
 * Decompiled with CFR 0.152.
 */
package io.logspace.agent.api;

import io.logspace.agent.api.AgentController;
import io.logspace.agent.api.AgentControllerDescription;
import io.logspace.agent.api.AgentControllerDescriptionFactory;
import io.logspace.agent.api.AgentControllerInitializationException;
import io.logspace.agent.api.util.ConsoleWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;

public final class AgentControllerProvider {
    public static final String PROPERTY_LOGSPACE_CONFIG = "logspace.config";
    private static final String[] CONFIG_LOCATIONS = new String[]{"/logspace-test.json", "/logspace.json", "/logspace-default.json"};
    private static AgentController agentController;
    private static AgentControllerDescription agentControllerDescription;

    private AgentControllerProvider() {
    }

    public static synchronized void flush() {
        if (agentController != null) {
            agentController.flush();
        }
    }

    public static synchronized AgentController getAgentController() {
        if (agentController == null) {
            agentController = AgentControllerProvider.initialize();
        }
        return agentController;
    }

    public static synchronized boolean isInitialized() {
        return agentController != null;
    }

    public static synchronized void setDescription(AgentControllerDescription agentControllerDescription) {
        if (AgentControllerProvider.isInitialized()) {
            throw new AgentControllerInitializationException("Cannot set a new description after the AgentController has already been initialized.");
        }
        AgentControllerProvider.agentControllerDescription = agentControllerDescription;
    }

    public static synchronized void setDescription(InputStream inputStream) {
        try {
            AgentControllerProvider.setDescription(AgentControllerDescriptionFactory.fromJson(inputStream));
        }
        catch (IOException ioex) {
            throw new AgentControllerInitializationException("Could not load logspace configuration.", ioex);
        }
        finally {
            AgentControllerProvider.closeQuietly(inputStream);
        }
    }

    public static synchronized void setDescription(URL descriptionURL) {
        if (descriptionURL == null) {
            return;
        }
        try {
            AgentControllerProvider.setDescription(descriptionURL.openStream());
            ConsoleWriter.writeSystem(MessageFormat.format("Loaded logspace configuration from ''{0}''.", descriptionURL));
        }
        catch (IOException ioex) {
            throw new AgentControllerInitializationException("Could not load logspace configuration from URL '" + descriptionURL + "'.", ioex);
        }
    }

    public static synchronized void shutdown() {
        if (agentController == null) {
            return;
        }
        agentController.flush();
        agentController.shutdown();
        agentController = null;
    }

    private static void closeQuietly(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Object executeConstructor(Constructor<?> constructor, Object ... arguments) {
        try {
            return constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new AgentControllerInitializationException("Failed to instantiate Agent Controller of class '" + constructor.getDeclaringClass() + "'.", e);
        }
    }

    private static Constructor<?> getConstructor(Constructor<?>[] constructors, Class<?> ... parameterTypes) {
        for (Constructor<?> eachConstructor : constructors) {
            if (!Arrays.equals(eachConstructor.getParameterTypes(), parameterTypes)) continue;
            return eachConstructor;
        }
        return null;
    }

    private static boolean hasDescription() {
        return agentControllerDescription != null;
    }

    private static AgentController initialize() {
        AgentControllerProvider.initializeDescription();
        Class<? extends AgentController> agentControllerClass = AgentControllerProvider.loadClass(agentControllerDescription);
        Constructor<?>[] constructors = agentControllerClass.getConstructors();
        Constructor<?> constructor = AgentControllerProvider.getConstructor(constructors, AgentControllerDescription.class);
        if (constructor != null) {
            return (AgentController)AgentControllerProvider.executeConstructor(constructor, agentControllerDescription);
        }
        constructor = AgentControllerProvider.getConstructor(constructors, new Class[0]);
        if (constructor != null) {
            return (AgentController)AgentControllerProvider.executeConstructor(constructor, new Object[0]);
        }
        throw new AgentControllerInitializationException("Could not find a suitable constructor for AgentController '" + agentControllerClass + "'. Either a constructor accepting " + AgentControllerDescription.class + " or a default constructor is required.");
    }

    private static void initializeDescription() {
        if (AgentControllerProvider.hasDescription()) {
            return;
        }
        AgentControllerProvider.initializeDescriptionFromSetting();
        if (AgentControllerProvider.hasDescription()) {
            return;
        }
        AgentControllerProvider.initializeDescriptionFromFile();
        if (AgentControllerProvider.hasDescription()) {
            return;
        }
        AgentControllerProvider.initializeDescriptionFromClasspath();
        if (!AgentControllerProvider.hasDescription()) {
            throw new AgentControllerInitializationException("Could not find any description.");
        }
    }

    private static void initializeDescriptionFromClasspath() {
        for (String eachConfigLocation : CONFIG_LOCATIONS) {
            if (AgentControllerProvider.hasDescription()) {
                return;
            }
            AgentControllerProvider.setDescription(AgentControllerProvider.class.getResource(eachConfigLocation));
        }
    }

    private static void initializeDescriptionFromFile() {
        File file = new File("logspace.json");
        if (!file.exists()) {
            return;
        }
        try {
            AgentControllerProvider.setDescription(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private static void initializeDescriptionFromSetting() {
        String logspaceConfig = System.getProperty(PROPERTY_LOGSPACE_CONFIG);
        if (logspaceConfig == null) {
            return;
        }
        try {
            AgentControllerProvider.setDescription(new URL(logspaceConfig));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (AgentControllerProvider.hasDescription()) {
            return;
        }
        File file = new File(logspaceConfig);
        if (!file.exists()) {
            throw new AgentControllerInitializationException("Could not load logspace configuration from the configured location '" + logspaceConfig + "'. Is the value correct?");
        }
        try {
            AgentControllerProvider.setDescription(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private static Class<? extends AgentController> loadClass(AgentControllerDescription description) {
        if (description.getClassName() == null) {
            throw new AgentControllerInitializationException("The Agent Controller class is unconfigured.");
        }
        try {
            return Class.forName(description.getClassName());
        }
        catch (ClassNotFoundException cnfex) {
            throw new AgentControllerInitializationException("Could not load Agent Controller class '" + description.getClassName() + "'.", cnfex);
        }
    }
}

