/*
 * Decompiled with CFR 0.152.
 */
package io.logspace.agent.api.event;

import io.logspace.agent.api.event.BooleanEventProperty;
import io.logspace.agent.api.event.DateEventProperty;
import io.logspace.agent.api.event.DoubleEventProperty;
import io.logspace.agent.api.event.Event;
import io.logspace.agent.api.event.EventBuilderData;
import io.logspace.agent.api.event.EventProperties;
import io.logspace.agent.api.event.FloatEventProperty;
import io.logspace.agent.api.event.ImmutableEvent;
import io.logspace.agent.api.event.IntegerEventProperty;
import io.logspace.agent.api.event.LongEventProperty;
import io.logspace.agent.api.event.StringEventProperty;
import java.util.Date;

public abstract class AbstractEventBuilder {
    private final EventBuilderData eventBuilderData;
    private String globalEventId;
    private String parentEventId;
    private final EventProperties properties = new EventProperties();

    protected AbstractEventBuilder(EventBuilderData eventBuilderData) {
        this.eventBuilderData = eventBuilderData;
    }

    public AbstractEventBuilder setGlobalEventId(String globalEventId) {
        this.globalEventId = globalEventId;
        return this;
    }

    public AbstractEventBuilder setParentEventId(String parentEventId) {
        this.parentEventId = parentEventId;
        return this;
    }

    public final Event toEvent() {
        return new ImmutableEvent(this.eventBuilderData.getAgentId(), this.eventBuilderData.getSystem(), this.getType(), this.globalEventId, this.parentEventId, this.eventBuilderData.getMarker(), this.properties);
    }

    protected final void addProperty(BooleanEventProperty property) {
        this.properties.add(property);
    }

    protected final void addProperty(DateEventProperty property) {
        this.properties.add(property);
    }

    protected final void addProperty(DoubleEventProperty property) {
        this.properties.add(property);
    }

    protected final void addProperty(FloatEventProperty property) {
        this.properties.add(property);
    }

    protected final void addProperty(IntegerEventProperty property) {
        this.properties.add(property);
    }

    protected final void addProperty(LongEventProperty property) {
        this.properties.add(property);
    }

    protected final void addProperty(String key, Boolean value) {
        this.properties.add(new BooleanEventProperty(key, value));
    }

    protected final void addProperty(String key, Date value) {
        this.properties.add(new DateEventProperty(key, value));
    }

    protected final void addProperty(String key, Double value) {
        this.addProperty(new DoubleEventProperty(key, value));
    }

    protected final void addProperty(String key, Float value) {
        this.properties.add(new FloatEventProperty(key, value));
    }

    protected final void addProperty(String key, Integer value) {
        this.properties.add(new IntegerEventProperty(key, value));
    }

    protected final void addProperty(String key, Long value) {
        this.properties.add(new LongEventProperty(key, value));
    }

    protected final void addProperty(String key, String value) {
        this.addProperty(new StringEventProperty(key, value));
    }

    protected final void addProperty(StringEventProperty property) {
        this.properties.add(property);
    }

    protected abstract String getType();
}

