/*
 * Decompiled with CFR 0.152.
 */
package io.logspace.agent.api.event;

import io.logspace.agent.api.event.EventProperty;
import java.text.MessageFormat;

public abstract class AbstractEventProperty<T>
implements EventProperty<T> {
    private final String key;
    private final T value;

    protected AbstractEventProperty(String key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("The key must not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value must not be null.");
        }
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventProperty other = (EventProperty)obj;
        if (this.getKey() == null ? other.getKey() != null : !this.getKey().equals(other.getKey())) {
            return false;
        }
        return !(this.getValue() == null ? other.getValue() != null : !this.getValue().equals(other.getValue()));
    }

    @Override
    public final String getKey() {
        return this.key;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + (this.key == null ? 0 : this.key.hashCode());
        return 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
    }

    public String toString() {
        return MessageFormat.format("[{0} = {1}]", this.key, this.value);
    }
}

