/*
 * Decompiled with CFR 0.152.
 */
package io.logspace.agent.api.event;

import io.logspace.agent.api.event.BooleanEventProperty;
import io.logspace.agent.api.event.DateEventProperty;
import io.logspace.agent.api.event.DoubleEventProperty;
import io.logspace.agent.api.event.Event;
import io.logspace.agent.api.event.EventProperties;
import io.logspace.agent.api.event.FloatEventProperty;
import io.logspace.agent.api.event.IntegerEventProperty;
import io.logspace.agent.api.event.LongEventProperty;
import io.logspace.agent.api.event.StringEventProperty;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;

public final class ImmutableEvent
implements Event {
    private final String id = UUID.randomUUID().toString();
    private final String agentId;
    private final Date timestamp;
    private final String type;
    private final String system;
    private final String marker;
    private final String globalEventId;
    private final String parentEventId;
    private final EventProperties properties;

    public ImmutableEvent(String agentId, String system, String type, String globalEventId, String parentEventId, String marker, EventProperties properties) {
        this.agentId = agentId;
        this.system = system;
        this.timestamp = new Date();
        this.type = type;
        this.globalEventId = globalEventId;
        this.parentEventId = parentEventId;
        this.marker = marker;
        this.properties = properties == null ? new EventProperties() : properties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableEvent other = (ImmutableEvent)obj;
        return this.id.equals(other.id);
    }

    @Override
    public String getAgentId() {
        return this.agentId;
    }

    @Override
    public Collection<BooleanEventProperty> getBooleanProperties() {
        return this.properties.getBooleanProperties();
    }

    @Override
    public Collection<DateEventProperty> getDateProperties() {
        return this.properties.getDateProperties();
    }

    @Override
    public Collection<DoubleEventProperty> getDoubleProperties() {
        return this.properties.getDoubleProperties();
    }

    @Override
    public Collection<FloatEventProperty> getFloatProperties() {
        return this.properties.getFloatProperties();
    }

    @Override
    public String getGlobalEventId() {
        return this.globalEventId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Collection<IntegerEventProperty> getIntegerProperties() {
        return this.properties.getIntegerProperties();
    }

    @Override
    public Collection<LongEventProperty> getLongProperties() {
        return this.properties.getLongProperties();
    }

    @Override
    public String getMarker() {
        return this.marker;
    }

    @Override
    public String getParentEventId() {
        return this.parentEventId;
    }

    @Override
    public Collection<StringEventProperty> getStringProperties() {
        return this.properties.getStringProperties();
    }

    @Override
    public String getSystem() {
        return this.system;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }
}

