/*
 * Decompiled with CFR 0.152.
 */
package io.logspace.agent.api.order;

import io.logspace.agent.api.order.Aggregate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum PropertyType {
    BOOLEAN(Aggregate.count),
    DATE(Aggregate.count, Aggregate.min, Aggregate.max, Aggregate.avg),
    INTEGER(Aggregate.count, Aggregate.min, Aggregate.max, Aggregate.avg, Aggregate.sum),
    LONG(Aggregate.count, Aggregate.min, Aggregate.max, Aggregate.avg, Aggregate.sum),
    FLOAT(Aggregate.count, Aggregate.min, Aggregate.max, Aggregate.avg, Aggregate.sum),
    DOUBLE(Aggregate.count, Aggregate.min, Aggregate.max, Aggregate.avg, Aggregate.sum),
    STRING(Aggregate.count);

    private static final Map<String, PropertyType> PROPERTY_TYPES;
    private final Set<Aggregate> allowedAggregates = new HashSet<Aggregate>();

    private PropertyType(Aggregate ... allowedAggregate) {
        for (Aggregate eachAllowedAggregate : allowedAggregate) {
            this.allowedAggregates.add(eachAllowedAggregate);
        }
    }

    public static PropertyType get(String name) {
        if (name == null) {
            return null;
        }
        return PROPERTY_TYPES.get(name.toLowerCase());
    }

    public Set<Aggregate> getAllowedAggregates() {
        return this.allowedAggregates;
    }

    public boolean isAllowed(Aggregate aggregate) {
        return this.allowedAggregates.contains((Object)aggregate);
    }

    static {
        PROPERTY_TYPES = new HashMap<String, PropertyType>();
        for (PropertyType eachValue : PropertyType.values()) {
            PROPERTY_TYPES.put(eachValue.name().toLowerCase(), eachValue);
        }
    }
}

