/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.donut.gherkin.model;

import io.magentys.donut.gherkin.model.Duration;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;

    static {
        new Duration$();
    }

    public Duration apply(long duration) {
        return new Duration(duration, this.calculateTotalDurationStr(duration));
    }

    public long calculateTotalDuration(List<Object> durations) {
        return BoxesRunTime.unboxToLong((Object)durations.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public String calculateTotalDurationStr(List<Object> durations) {
        return this.formatDuration(this.calculateTotalDuration(durations));
    }

    public String calculateTotalDurationStr(long duration) {
        return this.formatDuration(duration);
    }

    public String formatDuration(long duration) {
        PeriodFormatter formatter = new PeriodFormatterBuilder().appendDays().appendSuffix(" day", " days").appendSeparator(" and ").appendHours().appendSuffix(" hour", " hours").appendSeparator(" and ").appendMinutes().appendSuffix(" min", " mins").appendSeparator(" and ").appendSeconds().appendSuffix(" sec", " secs").appendSeparator(" and ").appendMillis().appendSuffix(" ms", " ms").toFormatter();
        return formatter.print((ReadablePeriod)new Period(0L, duration / 1000000L));
    }

    public long calculateDurationFrom2Strings(String startDateTime, String endDateTime) {
        long start = DateTime.parse((String)startDateTime).getMillis();
        long end = DateTime.parse((String)endDateTime).getMillis();
        return (end - start) * 1000000L;
    }

    public Duration apply(long duration, String durationStr) {
        return new Duration(duration, durationStr);
    }

    public Option<Tuple2<Object, String>> unapply(Duration x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)x$0.duration()), (Object)x$0.durationStr()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Duration$() {
        MODULE$ = this;
    }
}

