/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.donut.gherkin.model;

import io.magentys.donut.gherkin.model.Duration$;
import io.magentys.donut.gherkin.model.ExecutionDashboard;
import io.magentys.donut.gherkin.model.ExecutionData;
import io.magentys.donut.gherkin.model.Feature;
import io.magentys.donut.gherkin.model.Metrics;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple15;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.math.BigDecimal;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class ExecutionDashboard$
implements Serializable {
    public static final ExecutionDashboard$ MODULE$;

    static {
        new ExecutionDashboard$();
    }

    public ExecutionDashboard apply(List<Feature> features, ExecutionData executionData) {
        Metrics featuresMetrics = executionData.allFeatureMetrics();
        Metrics allTestsMetrics = executionData.allTestsMetrics();
        Metrics scenarioMetrics = executionData.allScenarioMetrics();
        Metrics unitTestMetrics = executionData.allUnitTestMetrics();
        return new ExecutionDashboard(featuresMetrics.total(), featuresMetrics, allTestsMetrics, scenarioMetrics, unitTestMetrics, executionData.allStepMetrics(), executionData.allTagSize(), this.failRate(featuresMetrics), this.passRate(featuresMetrics), this.failRate(scenarioMetrics), this.passRate(scenarioMetrics), this.failRate(unitTestMetrics), this.passRate(unitTestMetrics), Duration$.MODULE$.calculateTotalDurationStr((List<Object>)((List)features.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(Feature f) {
                return f.duration().duration();
            }
        }, List$.MODULE$.canBuildFrom()))), DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm").print((ReadableInstant)executionData.timestamp()));
    }

    public double passRate(Metrics metrics) {
        return this.rate(metrics.passed(), metrics.total());
    }

    public double failRate(Metrics metrics) {
        return this.rate(metrics.failed(), metrics.total());
    }

    public double rate(double metric, double totalMetrics) {
        return totalMetrics > 0.0 ? package$.MODULE$.BigDecimal().apply(metric / totalMetrics * (double)100).setScale(2, BigDecimal.RoundingMode$.MODULE$.HALF_UP()).toDouble() : 0.0;
    }

    public ExecutionDashboard apply(int totalFeatures, Metrics featureMetrics, Metrics allTestsMetrics, Metrics scenarioMetrics, Metrics unitTestMetrics, Metrics stepMetrics, int totalTags, double featureFailRate, double featurePassRate, double scenariosFailRate, double scenariosPassRate, double unitTestsFailRate, double unitTestsPassRate, String executionDuration, String executionDateTime) {
        return new ExecutionDashboard(totalFeatures, featureMetrics, allTestsMetrics, scenarioMetrics, unitTestMetrics, stepMetrics, totalTags, featureFailRate, featurePassRate, scenariosFailRate, scenariosPassRate, unitTestsFailRate, unitTestsPassRate, executionDuration, executionDateTime);
    }

    public Option<Tuple15<Object, Metrics, Metrics, Metrics, Metrics, Metrics, Object, Object, Object, Object, Object, Object, Object, String, String>> unapply(ExecutionDashboard x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple15((Object)BoxesRunTime.boxToInteger((int)x$0.totalFeatures()), (Object)x$0.featureMetrics(), (Object)x$0.allTestsMetrics(), (Object)x$0.scenarioMetrics(), (Object)x$0.unitTestMetrics(), (Object)x$0.stepMetrics(), (Object)BoxesRunTime.boxToInteger((int)x$0.totalTags()), (Object)BoxesRunTime.boxToDouble((double)x$0.featureFailRate()), (Object)BoxesRunTime.boxToDouble((double)x$0.featurePassRate()), (Object)BoxesRunTime.boxToDouble((double)x$0.scenariosFailRate()), (Object)BoxesRunTime.boxToDouble((double)x$0.scenariosPassRate()), (Object)BoxesRunTime.boxToDouble((double)x$0.unitTestsFailRate()), (Object)BoxesRunTime.boxToDouble((double)x$0.unitTestsPassRate()), (Object)x$0.executionDuration(), (Object)x$0.executionDateTime()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ExecutionDashboard$() {
        MODULE$ = this;
    }
}

