/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import io.mangoo.admin.AdminFilter;
import io.mangoo.annotations.FilterWith;
import io.mangoo.cache.Cache;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.Template;
import io.mangoo.models.Job;
import io.mangoo.models.Metrics;
import io.mangoo.routing.Response;
import io.mangoo.routing.Router;
import io.mangoo.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

@FilterWith(value={AdminFilter.class})
public class AdminController {
    private static final int MB = 0x100000;
    private final Map<String, String> properties = new HashMap<String, String>();

    public AdminController() {
        System.getProperties().entrySet().forEach(entry -> this.properties.put(entry.getKey().toString(), entry.getValue().toString()));
    }

    public Response health() {
        return Response.withOk().andTextBody("alive");
    }

    public Response routes() {
        return Response.withOk().andContent("routes", Router.getRoutes()).andTemplate(Template.DEFAULT.routesPath());
    }

    public Response cache() {
        Map<String, Object> map = Application.getInstance(Cache.class).getStats();
        return Response.withOk().andContent("stats", map).andTemplate(Template.DEFAULT.cachePath());
    }

    public Response config() {
        Map<String, String> map = Application.getConfig().getAllConfigurations();
        map.remove(Key.APPLICATION_SECRET.toString());
        return Response.withOk().andContent("configuration", map).andTemplate(Template.DEFAULT.configPath());
    }

    public Response metrics() {
        Metrics metrics = Application.getInstance(Metrics.class);
        return Response.withOk().andContent("metrics", metrics.getMetrics()).andTemplate(Template.DEFAULT.metricsPath());
    }

    public Response system() {
        return Response.withOk().andContent("properties", this.properties).andTemplate(Template.DEFAULT.propertiesPath());
    }

    public Response memory() {
        Runtime runtime = Runtime.getRuntime();
        double d = (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
        double d2 = runtime.freeMemory() / 0x100000L;
        double d3 = runtime.totalMemory() / 0x100000L;
        double d4 = runtime.maxMemory() / 0x100000L;
        return Response.withOk().andContent("usedMemory", d).andContent("freeMemory", d2).andContent("totalMemory", d3).andContent("maxMemory", d4).andTemplate(Template.DEFAULT.memoryPath());
    }

    public Response scheduler() throws SchedulerException {
        ArrayList<Job> arrayList = new ArrayList<Job>();
        org.quartz.Scheduler scheduler = Application.getInstance(Scheduler.class).getScheduler();
        if (scheduler != null) {
            Set set = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)Default.SCHEDULER_JOB_GROUP.toString()));
            for (JobKey jobKey : set) {
                List list = scheduler.getTriggersOfJob(jobKey);
                Trigger trigger = (Trigger)list.get(0);
                Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
                arrayList.add(new Job(!Trigger.TriggerState.PAUSED.equals((Object)triggerState), jobKey.getName(), trigger.getDescription(), trigger.getNextFireTime(), trigger.getPreviousFireTime()));
            }
        }
        return Response.withOk().andContent("jobs", arrayList).andTemplate(Template.DEFAULT.schedulerPath());
    }
}

