/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.admin;

import com.google.common.base.Charsets;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.AdminRoute;
import io.mangoo.enums.Default;
import io.mangoo.enums.Template;
import io.mangoo.interfaces.MangooFilter;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.undertow.util.Headers;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;

public class AdminFilter
implements MangooFilter {
    private static final Config CONFIG = Application.getConfig();

    @Override
    public Response execute(Request request, Response response) {
        String string = Optional.ofNullable(request.getURI()).orElse("").replace("/", "");
        if (this.isURLEnabled(string)) {
            if (CONFIG.isAdminAuthenticationEnabled() && !this.isAuthenticated(request)) {
                return Response.withUnauthorized().andHeader(Headers.WWW_AUTHENTICATE, "Basic realm=Administration authentication").andEmptyBody().end();
            }
            return response;
        }
        return Response.withNotFound().andBody(Template.DEFAULT.notFound()).end();
    }

    private boolean isAuthenticated(Request request) {
        String string = null;
        String string2 = null;
        String string3 = request.getHeader(Headers.AUTHORIZATION);
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            string3 = string3.replace("Basic", "");
            string3 = string3.trim();
            String[] stringArray = (string3 = new String(Base64.decode((String)string3), Charsets.UTF_8)).split(":");
            if (stringArray != null && stringArray.length == Default.BASICAUTH_CREDENTIALS_LENGTH.toInt()) {
                string = stringArray[0];
                string2 = stringArray[1];
            }
        }
        return StringUtils.isNotBlank(string) && StringUtils.isNotBlank(string2) && CONFIG.getAdminAuthenticationUser().equals(string) && CONFIG.getAdminAuthenticationPassword().equals(DigestUtils.sha512Hex(string2));
    }

    private boolean isURLEnabled(String string) {
        boolean bl;
        Objects.requireNonNull(string, "url can not be null");
        if ('/' != string.charAt(0)) {
            string = '/' + string;
        }
        switch (AdminRoute.fromString(string)) {
            case ROUTES: {
                bl = CONFIG.isAdminRoutesEnabled();
                break;
            }
            case CONFIG: {
                bl = CONFIG.isAdminConfigEnabled();
                break;
            }
            case HEALTH: {
                bl = CONFIG.isAdminHealthEnabled();
                break;
            }
            case CACHE: {
                bl = CONFIG.isAdminCacheEnabled();
                break;
            }
            case METRICS: {
                bl = CONFIG.isAdminMetricsEnabled();
                break;
            }
            case SCHEDULER: {
                bl = CONFIG.isAdminSchedulerEnabled();
                break;
            }
            case SYSTEM: {
                bl = CONFIG.isAdminSystemEnabled();
                break;
            }
            case MEMORY: {
                bl = CONFIG.isAdminMemoryEnabled();
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

