/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.authentication;

import io.mangoo.enums.Default;
import io.mangoo.models.OAuthUser;
import java.time.LocalDateTime;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mindrot.jbcrypt.BCrypt;

public class Authentication {
    private static final Logger LOG = LogManager.getLogger(Authentication.class);
    private LocalDateTime expires;
    private OAuthUser oAuthUser;
    private String authenticatedUser;
    private boolean remember;
    private boolean loggedOut;

    public Authentication() {
    }

    public Authentication(LocalDateTime localDateTime, String string) {
        this.expires = localDateTime;
        this.authenticatedUser = string;
    }

    public String getAuthenticatedUser() {
        return this.authenticatedUser;
    }

    public LocalDateTime getExpires() {
        return this.expires;
    }

    public boolean isLogout() {
        return this.loggedOut;
    }

    public boolean isRemember() {
        return this.remember;
    }

    public void setOAuthUser(OAuthUser oAuthUser) {
        if (this.oAuthUser == null) {
            this.oAuthUser = oAuthUser;
        }
    }

    public OAuthUser getOAuthUser() {
        return this.oAuthUser;
    }

    public String getHashedPassword(String string) {
        Objects.requireNonNull(string, "password is required for getHashedPassword");
        return BCrypt.hashpw((String)string, (String)BCrypt.gensalt((int)Default.JBCRYPT_ROUNDS.toInt()));
    }

    public boolean authenticate(String string, String string2) {
        Objects.requireNonNull(string, "password is required for authenticate");
        Objects.requireNonNull(string2, "Hashed password is required for authenticate");
        boolean bl = false;
        try {
            bl = BCrypt.checkpw((String)string, (String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.error("Failed to check password against hash", (Throwable)illegalArgumentException);
        }
        return bl;
    }

    public void logout() {
        this.loggedOut = true;
    }

    public void login(String string, boolean bl) {
        Objects.requireNonNull(string, "Username is required for login");
        if (StringUtils.isNotBlank((CharSequence)StringUtils.trimToNull((String)string))) {
            this.authenticatedUser = string;
            this.remember = bl;
        }
    }

    public void login(String string) {
        Objects.requireNonNull(string, "username is required for isAuthenticated");
        this.login(string, false);
    }

    public boolean hasAuthenticatedUser() {
        return StringUtils.isNotBlank((CharSequence)this.authenticatedUser) || this.oAuthUser != null;
    }

    public boolean isAuthenticated(String string) {
        Objects.requireNonNull(string, "username is required for isAuthenticated");
        return string.equals(this.authenticatedUser);
    }
}

