/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.authentication.oauth;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.exceptions.OAuthException;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuth20ServiceImpl;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.OAuthEncoder;
import org.scribe.utils.Preconditions;

public class Google2Api
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://accounts.google.com/o/oauth2/auth?response_type=code&client_id=%s&redirect_uri=%s";
    private static final String SCOPED_AUTHORIZE_URL = "https://accounts.google.com/o/oauth2/auth?response_type=code&client_id=%s&redirect_uri=%s&scope=%s";
    private static final String ACCESS_TOKEN_ENDPOINT = "https://accounts.google.com/o/oauth2/token";
    private static final Pattern PATTERN = Pattern.compile("\"access_token\" : \"([^&\"]+)\"");

    public String getAccessTokenEndpoint() {
        return ACCESS_TOKEN_ENDPOINT;
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new GoogleApi2AccessTokenExtractor();
    }

    public String getAuthorizationUrl(OAuthConfig oAuthConfig) {
        Objects.requireNonNull(oAuthConfig, "config can not be null");
        if (oAuthConfig.hasScope()) {
            return String.format(SCOPED_AUTHORIZE_URL, oAuthConfig.getApiKey(), OAuthEncoder.encode((String)oAuthConfig.getCallback()), OAuthEncoder.encode((String)oAuthConfig.getScope()));
        }
        return String.format(AUTHORIZE_URL, oAuthConfig.getApiKey(), OAuthEncoder.encode((String)oAuthConfig.getCallback()));
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public OAuthService createService(OAuthConfig oAuthConfig) {
        Objects.requireNonNull(oAuthConfig, "config can not be null");
        return new GoogleOAuth2Service(this, oAuthConfig);
    }

    private class GoogleOAuth2Service
    extends OAuth20ServiceImpl {
        private static final String AUTHORIZATION_CODE = "authorization_code";
        private static final String GRANT_TYPE = "grant_type";
        private final DefaultApi20 api;
        private final OAuthConfig config;

        public GoogleOAuth2Service(DefaultApi20 defaultApi20, OAuthConfig oAuthConfig) {
            super(defaultApi20, oAuthConfig);
            this.api = defaultApi20;
            this.config = oAuthConfig;
        }

        public Token getAccessToken(Token token, Verifier verifier) {
            OAuthRequest oAuthRequest = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
            switch (this.api.getAccessTokenVerb()) {
                case POST: {
                    oAuthRequest.addBodyParameter("client_id", this.config.getApiKey());
                    oAuthRequest.addBodyParameter("client_secret", this.config.getApiSecret());
                    oAuthRequest.addBodyParameter("code", verifier.getValue());
                    oAuthRequest.addBodyParameter("redirect_uri", this.config.getCallback());
                    oAuthRequest.addBodyParameter(GRANT_TYPE, AUTHORIZATION_CODE);
                    break;
                }
                default: {
                    oAuthRequest.addQuerystringParameter("client_id", this.config.getApiKey());
                    oAuthRequest.addQuerystringParameter("client_secret", this.config.getApiSecret());
                    oAuthRequest.addQuerystringParameter("code", verifier.getValue());
                    oAuthRequest.addQuerystringParameter("redirect_uri", this.config.getCallback());
                    if (!this.config.hasScope()) break;
                    oAuthRequest.addQuerystringParameter("scope", this.config.getScope());
                }
            }
            Response response = oAuthRequest.send();
            return this.api.getAccessTokenExtractor().extract(response.getBody());
        }
    }

    private static class GoogleApi2AccessTokenExtractor
    implements AccessTokenExtractor {
        private GoogleApi2AccessTokenExtractor() {
        }

        public Token extract(String string) {
            Preconditions.checkEmptyString((String)string, (String)"Response body is incorrect. Can't extract a token from an empty string");
            Matcher matcher = PATTERN.matcher(string);
            if (matcher.find()) {
                String string2 = OAuthEncoder.decode((String)matcher.group(1));
                return new Token(string2, "", string);
            }
            throw new OAuthException("Response body is incorrect. Can't extract a token from this: '" + string + "'", null);
        }
    }
}

