/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.inject.Singleton;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class Cache {
    private static final Logger LOG = LogManager.getLogger(Cache.class);
    private static final Config CONFIG = Application.getConfig();
    private static final String VALUE_REQUIRED = "For a new cache entry a non null value is required";
    private static final String KEY_REQUIRED = "For a new cache entry a non null key is required";
    private final com.google.common.cache.Cache<String, Object> guavaCache;

    public Cache() {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize((long)CONFIG.getInt(Key.CACHE_MAX_SIZE, Default.CACHE_MAX_SIZE.toInt()));
        String string = CONFIG.getString(Key.CACHE_EVICTION, Default.CACHE_EXPIRES.toString());
        int n = CONFIG.getInt(Key.CACHE_EXPIRES, Default.CACHE_EXPIRES_ACCESS.toInt());
        if ("afterAccess".equalsIgnoreCase(string)) {
            cacheBuilder.expireAfterAccess((long)n, TimeUnit.SECONDS);
        } else if ("afterWrite".equalsIgnoreCase(string)) {
            cacheBuilder.expireAfterWrite((long)n, TimeUnit.SECONDS);
        } else {
            cacheBuilder.expireAfterAccess((long)n, TimeUnit.SECONDS);
        }
        if (CONFIG.getBoolean(Key.APPLICATION_ADMIN_CACHE)) {
            cacheBuilder.recordStats();
        }
        this.guavaCache = cacheBuilder.build();
    }

    public void put(String string, Object object) {
        Objects.requireNonNull(string, KEY_REQUIRED);
        Objects.requireNonNull(object, VALUE_REQUIRED);
        this.guavaCache.put((Object)string, object);
    }

    public void remove(String string) {
        Objects.requireNonNull(string, KEY_REQUIRED);
        this.guavaCache.invalidate((Object)string);
    }

    public long size() {
        return this.guavaCache.size();
    }

    public void clear() {
        this.guavaCache.invalidateAll();
    }

    public <T> T get(String string) {
        Objects.requireNonNull(string, KEY_REQUIRED);
        Object object = this.guavaCache.getIfPresent((Object)string);
        return (T)(object == null ? null : object);
    }

    public <T> T get(String string, Callable<? extends Object> callable) {
        Objects.requireNonNull(string, KEY_REQUIRED);
        Objects.requireNonNull(callable, "callable can not be null");
        Object object = this.guavaCache.getIfPresent((Object)string);
        if (object == null) {
            try {
                object = this.guavaCache.get((Object)string, callable);
            }
            catch (ExecutionException executionException) {
                LOG.error("Failed to get Cached value", (Throwable)executionException);
            }
        }
        return (T)(object == null ? null : object);
    }

    public void putAll(Map<String, Object> map) {
        Objects.requireNonNull(map, "map can not be null");
        this.guavaCache.putAll(map);
    }

    public ConcurrentMap<String, Object> getAll() {
        return this.guavaCache.asMap();
    }

    public Map<String, Object> getStats() {
        CacheStats cacheStats = this.guavaCache.stats();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Average load penalty", cacheStats.averageLoadPenalty());
        hashMap.put("Eviction count", cacheStats.evictionCount());
        hashMap.put("Hit count", cacheStats.hitCount());
        hashMap.put("Hit rate", cacheStats.hitRate());
        hashMap.put("Load count", cacheStats.loadCount());
        hashMap.put("Load exception count", cacheStats.loadExceptionCount());
        hashMap.put("Load exception rate", cacheStats.loadExceptionRate());
        hashMap.put("Load success rate", cacheStats.loadSuccessCount());
        hashMap.put("Miss count", cacheStats.missCount());
        hashMap.put("Request count", cacheStats.requestCount());
        hashMap.put("Total load time in ns", cacheStats.totalLoadTime());
        return hashMap;
    }
}

