/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.configuration;

import com.google.common.io.Resources;
import com.google.inject.Singleton;
import io.mangoo.core.Application;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.Mode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.yaml.snakeyaml.Yaml;

@Singleton
public class Config {
    private static final Logger LOG = LogManager.getLogger(Config.class);
    private final Map<String, String> values = new ConcurrentHashMap<String, String>(16, 0.9f, 1);

    public Config() {
        this.prepare(Default.CONFIGURATION_FILE.toString(), Application.getMode());
    }

    public Config(String string, Mode mode) {
        Objects.requireNonNull(string, "configFile can not be null");
        Objects.requireNonNull(mode, "mode can not be null");
        this.prepare(string, mode);
    }

    private void prepare(String string, Mode mode) {
        String string2 = System.getProperty(Key.APPLICATION_CONFIG.toString());
        Map map = StringUtils.isNotBlank((CharSequence)string2) ? (Map)this.loadConfiguration(string2, false) : (Map)this.loadConfiguration(string, true);
        if (map != null) {
            Map map2 = (Map)map.get(Default.DEFAULT_CONFIGURATION.toString());
            Map map3 = (Map)map.get(mode.toString());
            this.load("", map2);
            if (map3 != null && !map3.isEmpty()) {
                this.load("", map3);
            }
        }
    }

    private Object loadConfiguration(String string, boolean bl) {
        InputStream inputStream = null;
        try {
            inputStream = bl ? Resources.getResource((String)string).openStream() : new FileInputStream(new File(string));
        }
        catch (IOException iOException) {
            LOG.error("Failed to load application.yaml", (Throwable)iOException);
        }
        Object object = null;
        if (inputStream != null) {
            Yaml yaml = new Yaml();
            object = yaml.load(inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return object;
    }

    private void load(String string, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string2 = entry.getKey();
            Object object = entry.getValue();
            if (string2 == null) continue;
            if (object instanceof Map) {
                this.load(string + "." + string2, (Map)object);
                continue;
            }
            this.values.put(StringUtils.substringAfter((String)(string + "." + string2), (String)"."), object == null ? "" : String.valueOf(object));
        }
    }

    public String getString(String string) {
        return this.values.get(string);
    }

    public String getString(String string, String string2) {
        return this.values.getOrDefault(string, string2);
    }

    public int getInt(String string) {
        String string2 = this.values.get(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return 0;
        }
        return Integer.valueOf(string2);
    }

    public long getLong(String string) {
        String string2 = this.values.get(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return 0L;
        }
        return Long.valueOf(string2);
    }

    public long getLong(String string, long l) {
        String string2 = this.values.get(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return l;
        }
        return Long.valueOf(string2);
    }

    public int getInt(String string, int n) {
        String string2 = this.values.get(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return n;
        }
        return Integer.valueOf(string2);
    }

    public boolean getBoolean(String string) {
        String string2 = this.values.get(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.values.get(string);
        if (StringUtils.isBlank((CharSequence)string2)) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public String getString(Key key) {
        return this.getString(key.toString());
    }

    public String getString(Key key, String string) {
        return this.getString(key.toString(), string);
    }

    public long getLong(Key key) {
        return this.getLong(key.toString());
    }

    public long getLong(Key key, long l) {
        return this.getLong(key.toString(), l);
    }

    public int getInt(Key key) {
        return this.getInt(key.toString());
    }

    public int getInt(Key key, int n) {
        return this.getInt(key.toString(), n);
    }

    public boolean getBoolean(Key key) {
        return this.getBoolean(key.toString());
    }

    public boolean getBoolean(Key key, boolean bl) {
        return this.getBoolean(key.toString(), bl);
    }

    public Map<String, String> getAllConfigurations() {
        return new ConcurrentHashMap<String, String>(this.values);
    }

    public boolean hasValidSecret() {
        String string = this.getString(Key.APPLICATION_SECRET);
        return StringUtils.isNotBlank((CharSequence)string) && string.length() >= Default.APPLICATION_SECRET_MIN_LENGTH.toInt();
    }

    public String getApplicationName() {
        return this.getString(Key.APPLICATION_NAME);
    }

    public String getApplicationHost() {
        return this.getString(Key.APPLICATION_HOST);
    }

    public int getApplicationPort() {
        return this.getInt(Key.APPLICATION_PORT);
    }

    public String getFlashCookieName() {
        return Default.FLASH_COOKIE_NAME.toString();
    }

    public String getSessionCookieName() {
        return this.getString(Key.COOKIE_NAME, Default.COOKIE_NAME.toString());
    }

    public String getApplicationSecret() {
        return this.getString(Key.APPLICATION_SECRET);
    }

    public String getAuthenticationCookieName() {
        return this.getString(Key.AUTH_COOKIE_NAME, Default.AUTH_COOKIE_NAME.toString());
    }

    public long getAuthenticationExpires() {
        return this.getLong(Key.AUTH_COOKIE_EXPIRES, Default.AUTH_COOKIE_EXPIRES.toLong());
    }

    public long getSessionExpires() {
        return this.getLong(Key.COOKIE_EXPIRES, Default.COOKIE_EXPIRES.toLong());
    }

    public boolean isSessionCookieSecure() {
        return this.getBoolean(Key.COOKIE_SECURE, Default.COOKIE_SECURE.toBoolean());
    }

    public boolean isAuthenticationCookieSecure() {
        return this.getBoolean(Key.AUTH_COOKIE_SECURE, Default.AUTH_COOKIE_SECURE.toBoolean());
    }

    public String getI18nCookieName() {
        return this.getString(Key.COOKIE_I18N_NAME, Default.COOKIE_I18N_NAME.toString());
    }

    public boolean isFlashCookieSecure() {
        return this.isSessionCookieSecure();
    }

    public String getApplicationLanguage() {
        return this.getString(Key.APPLICATION_LANGUAGE, Default.LANGUAGE.toString());
    }

    public boolean isAdminHealthEnabled() {
        return this.getBoolean(Key.APPLICATION_ADMIN_HEALTH, Default.APPLICATION_ADMIN_HEALTH.toBoolean());
    }

    public boolean isAdminRoutesEnabled() {
        return this.getBoolean(Key.APPLICATION_ADMIN_ROUTES, Default.APPLICATION_ADMIN_ROUTES.toBoolean());
    }

    public boolean isAdminCacheEnabled() {
        return this.getBoolean(Key.APPLICATION_ADMIN_CACHE, Default.APPLICATION_ADMIN_CACHE.toBoolean());
    }

    public boolean isAdminConfigEnabled() {
        return this.getBoolean(Key.APPLICATION_ADMIN_CONFIG, Default.APPLICATION_ADMIN_CONFIG.toBoolean());
    }

    public boolean isAdminMetricsEnabled() {
        return this.getBoolean(Key.APPLICATION_ADMIN_METRICS, Default.APPLICATION_ADMIN_METRICS.toBoolean());
    }

    public boolean isAdminSchedulerEnabled() {
        return this.getBoolean(Key.APPLICATION_ADMIN_SCHEDULER, Default.APPLICATION_ADMIN_SCHEDULER.toBoolean());
    }

    public boolean isAdminSystemEnabled() {
        return this.getBoolean(Key.APPLICATION_ADMIN_SYSTEM, Default.APPLICATION_ADMIN_SYSTEM.toBoolean());
    }

    public boolean isAdminMemoryEnabled() {
        return this.getBoolean(Key.APPLICATION_ADMIN_MEMORY, Default.APPLICATION_ADMIN_MEMORY.toBoolean());
    }

    public boolean isAuthenticationCookieEncrypt() {
        return this.getBoolean(Key.AUTH_COOKIE_ENCRYPT, Default.AUTH_COOKIE_ENCRYPT.toBoolean());
    }

    public String getAuthCookieVersion() {
        return this.getString(Key.AUTH_COOKIE_VERSION, Default.AUTH_COOKIE_VERSION.toString());
    }

    public String getCookieVersion() {
        return this.getString(Key.COOKIE_VERSION, Default.COOKIE_VERSION.toString());
    }

    public boolean isSchedulerAutostart() {
        return this.getBoolean(Key.SCHEDULER_AUTOSTART, Default.SCHEDULER_AUTOSTART.toBoolean());
    }

    public boolean isAdminAuthenticationEnabled() {
        return StringUtils.isNotBlank((CharSequence)this.getString(Key.APPLICATION_ADMIN_USERNAME)) && StringUtils.isNotBlank((CharSequence)this.getString(Key.APPLICATION_ADMIN_PASSWORD));
    }

    public String getAdminAuthenticationUser() {
        return this.getString(Key.APPLICATION_ADMIN_USERNAME);
    }

    public String getAdminAuthenticationPassword() {
        return this.getString(Key.APPLICATION_ADMIN_PASSWORD);
    }

    public String getSchedulerPackage() {
        return this.getString(Key.SCHEDULER_PACKAGE, Default.SCHEDULER_PACKAGE.toString());
    }

    public boolean isSessionCookieEncrypt() {
        return this.getBoolean(Key.COOKIE_ENCRYPTION, Default.COOKIE_ENCRYPTION.toBoolean());
    }

    public long getAuthenticationRememberExpires() {
        return this.getLong(Key.AUTH_COOKIE_REMEMBER_EXPIRES, Default.AUTH_COOKIE_REMEMBER_EXPIRES.toLong());
    }

    public int getExecutionPool() {
        return this.getInt(Key.EXECUTION_THREADPOOL, Default.EXECUTION_THREADPOOL.toInt());
    }

    public String getControllerPackage() {
        return this.getString(Key.APPLICATION_CONTROLLER, Default.APPLICATION_CONTROLLER.toString());
    }

    public boolean isTimerEnabled() {
        return this.getBoolean(Key.APPLICATION_TIMER, Default.APPLICATION_TIMER.toBoolean());
    }
}

