/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.inject.Injector;
import io.mangoo.configuration.Config;
import io.mangoo.core.Bootstrap;
import io.mangoo.enums.Mode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;

public final class Application {
    private static volatile Mode mode;
    private static volatile Injector injector;
    private static volatile LocalDateTime start;
    private static volatile boolean started;

    private Application() {
    }

    public static void main(String ... stringArray) {
        Bootstrap bootstrap = new Bootstrap();
        start = bootstrap.getStart();
        mode = bootstrap.prepareMode();
        injector = bootstrap.prepareInjector();
        bootstrap.prepareLogger();
        bootstrap.applicationInitialized();
        bootstrap.prepareConfig();
        bootstrap.parseRoutes();
        bootstrap.startQuartzScheduler();
        bootstrap.startUndertow();
        bootstrap.showLogo();
        bootstrap.applicationStarted();
        if (bootstrap.isBootstrapSuccessful()) {
            started = true;
        } else {
            System.out.print("Failed to start mangoo I/O application");
            System.exit(1);
        }
    }

    public static boolean inDevMode() {
        return Mode.DEV.equals((Object)mode);
    }

    public static boolean inProdMode() {
        return Mode.PROD.equals((Object)mode);
    }

    public static boolean inTestMode() {
        return Mode.TEST.equals((Object)mode);
    }

    public static Mode getMode() {
        return mode;
    }

    public static Injector getInjector() {
        return injector;
    }

    public static boolean isStarted() {
        return started;
    }

    public static LocalDateTime getStart() {
        return start;
    }

    public static Config getConfig() {
        Objects.requireNonNull(mode, "cant't create config instance without application mode");
        return Application.getInstance(Config.class);
    }

    public static Duration getUptime() {
        Objects.requireNonNull(start, "can't calculate duration without application start time");
        return Duration.between(start, LocalDateTime.now());
    }

    public static <T> T getInstance(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz can not be null");
        return (T)injector.getInstance(clazz);
    }
}

