/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.core;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.mangoo.admin.AdminController;
import io.mangoo.annotations.Schedule;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.core.Modules;
import io.mangoo.enums.AdminRoute;
import io.mangoo.enums.Default;
import io.mangoo.enums.Key;
import io.mangoo.enums.Mode;
import io.mangoo.enums.RouteType;
import io.mangoo.interfaces.MangooLifecycle;
import io.mangoo.routing.Route;
import io.mangoo.routing.Router;
import io.mangoo.routing.handlers.DispatcherHandler;
import io.mangoo.routing.handlers.ExceptionHandler;
import io.mangoo.routing.handlers.FallbackHandler;
import io.mangoo.routing.handlers.ServerSentEventHandler;
import io.mangoo.routing.handlers.WebSocketHandler;
import io.mangoo.scheduler.Scheduler;
import io.mangoo.utils.BootstrapUtils;
import io.mangoo.utils.SchedulerUtils;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.sse.ServerSentEventConnectionCallback;
import io.undertow.util.Methods;
import io.undertow.websockets.WebSocketConnectionCallback;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.quartz.CronExpression;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class Bootstrap {
    private static volatile Logger LOG;
    private static final int INITIAL_SIZE = 255;
    private final LocalDateTime start = LocalDateTime.now();
    private final ResourceHandler pathResourceHandler = new ResourceHandler((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), Default.FILES_FOLDER.toString() + "/"));
    private PathHandler pathHandler;
    private Config config;
    private String host;
    private Mode mode;
    private Injector injector;
    private boolean error;
    private int port;

    public Mode prepareMode() {
        String string = System.getProperty(Key.APPLICATION_MODE.toString());
        if (StringUtils.isNotBlank((CharSequence)string)) {
            switch (string.toLowerCase(Locale.ENGLISH)) {
                case "dev": {
                    this.mode = Mode.DEV;
                    break;
                }
                case "test": {
                    this.mode = Mode.TEST;
                    break;
                }
                default: {
                    this.mode = Mode.PROD;
                    break;
                }
            }
        } else {
            this.mode = Mode.PROD;
        }
        return this.mode;
    }

    public void prepareLogger() {
        String string = "log4j2." + this.mode.toString() + ".xml";
        if (Thread.currentThread().getContextClassLoader().getResource(string) == null) {
            LOG = LogManager.getLogger(Bootstrap.class);
        } else {
            try {
                URL uRL = Thread.currentThread().getContextClassLoader().getResource(string);
                LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                loggerContext.setConfigLocation(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
                this.error = true;
            }
            if (!this.hasError()) {
                LOG = LogManager.getLogger(Bootstrap.class);
                LOG.info("Found environment specific Log4j2 configuration. Using configuration file: " + string);
            }
        }
    }

    public Injector prepareInjector() {
        this.injector = Guice.createInjector((Stage)Stage.PRODUCTION, this.getModules());
        return this.injector;
    }

    public void applicationInitialized() {
        ((MangooLifecycle)this.injector.getInstance(MangooLifecycle.class)).applicationInitialized();
    }

    public void prepareConfig() {
        this.config = (Config)this.injector.getInstance(Config.class);
        if (!this.config.hasValidSecret()) {
            LOG.error("Please make sure that your application.yaml has an application.secret property which has at least 16 characters");
            this.error = true;
        }
    }

    /*
     * Exception decompiling
     */
    public void parseRoutes() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean methodExists(String string, Class<?> clazz) {
        boolean bl = false;
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            LOG.error("Could not find controller method '" + string + "' in controller class '" + clazz.getSimpleName() + "'");
            this.error = true;
        }
        return bl;
    }

    private void createRoutes() {
        this.pathHandler = new PathHandler((HttpHandler)this.getRoutingHandler());
        for (Route route : Router.getRoutes()) {
            if (RouteType.WEBSOCKET.equals((Object)route.getRouteType())) {
                this.pathHandler.addExactPath(route.getUrl(), (HttpHandler)Handlers.websocket((WebSocketConnectionCallback)new WebSocketHandler(route.getControllerClass(), route.isAuthenticationRequired())));
                continue;
            }
            if (RouteType.SERVER_SENT_EVENT.equals((Object)route.getRouteType())) {
                this.pathHandler.addExactPath(route.getUrl(), (HttpHandler)Handlers.serverSentEvents((ServerSentEventConnectionCallback)new ServerSentEventHandler(route.isAuthenticationRequired())));
                continue;
            }
            if (!RouteType.RESOURCE_PATH.equals((Object)route.getRouteType())) continue;
            this.pathHandler.addPrefixPath(route.getUrl(), (HttpHandler)new ResourceHandler((ResourceManager)new ClassPathResourceManager(Thread.currentThread().getContextClassLoader(), Default.FILES_FOLDER.toString() + route.getUrl())));
        }
    }

    private RoutingHandler getRoutingHandler() {
        RoutingHandler routingHandler = Handlers.routing();
        routingHandler.setFallbackHandler((HttpHandler)Application.getInstance(FallbackHandler.class));
        Router.addRoute(new Route(RouteType.REQUEST).toUrl(AdminRoute.ROUTES.toString()).withRequest(Methods.GET).withClass(AdminController.class).withMethod("routes"));
        Router.addRoute(new Route(RouteType.REQUEST).toUrl(AdminRoute.CONFIG.toString()).withRequest(Methods.GET).withClass(AdminController.class).withMethod("config"));
        Router.addRoute(new Route(RouteType.REQUEST).toUrl(AdminRoute.HEALTH.toString()).withRequest(Methods.GET).withClass(AdminController.class).withMethod("health"));
        Router.addRoute(new Route(RouteType.REQUEST).toUrl(AdminRoute.CACHE.toString()).withRequest(Methods.GET).withClass(AdminController.class).withMethod("cache"));
        Router.addRoute(new Route(RouteType.REQUEST).toUrl(AdminRoute.METRICS.toString()).withRequest(Methods.GET).withClass(AdminController.class).withMethod("metrics"));
        Router.addRoute(new Route(RouteType.REQUEST).toUrl(AdminRoute.SCHEDULER.toString()).withRequest(Methods.GET).withClass(AdminController.class).withMethod("scheduler"));
        Router.addRoute(new Route(RouteType.REQUEST).toUrl(AdminRoute.SYSTEM.toString()).withRequest(Methods.GET).withClass(AdminController.class).withMethod("system"));
        Router.addRoute(new Route(RouteType.REQUEST).toUrl(AdminRoute.MEMORY.toString()).withRequest(Methods.GET).withClass(AdminController.class).withMethod("memory"));
        Router.getRoutes().parallelStream().forEach(route -> {
            if (RouteType.REQUEST.equals((Object)route.getRouteType())) {
                routingHandler.add(route.getRequestMethod(), route.getUrl(), (HttpHandler)new DispatcherHandler(route.getControllerClass(), route.getControllerMethod(), route.isBlockingAllowed()));
            } else if (RouteType.RESOURCE_FILE.equals((Object)route.getRouteType())) {
                routingHandler.add(Methods.GET, route.getUrl(), (HttpHandler)this.pathResourceHandler);
            }
        });
        return routingHandler;
    }

    public void startUndertow() {
        if (!this.hasError()) {
            this.host = this.config.getString(Key.APPLICATION_HOST, Default.APPLICATION_HOST.toString());
            this.port = this.config.getInt(Key.APPLICATION_PORT, Default.APPLICATION_PORT.toInt());
            Undertow undertow = Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)Handlers.exceptionHandler((HttpHandler)this.pathHandler).addExceptionHandler(Throwable.class, (HttpHandler)Application.getInstance(ExceptionHandler.class))).build();
            undertow.start();
        }
    }

    private List<Module> getModules() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        if (!this.hasError()) {
            try {
                Class<?> clazz = Class.forName(Default.MODULE_CLASS.toString());
                AbstractModule abstractModule = (AbstractModule)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                arrayList.add((Module)abstractModule);
                arrayList.add((Module)new Modules());
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                LOG.error("Failed to load modules. Check that conf/Module.java exists in your application", (Throwable)exception);
                this.error = true;
            }
        }
        return arrayList;
    }

    public void showLogo() {
        if (!this.hasError()) {
            StringBuilder stringBuilder = new StringBuilder(255);
            stringBuilder.append('\n').append(BootstrapUtils.getLogo()).append("\n\nhttps://mangoo.io | @mangoo_io | ").append(BootstrapUtils.getVersion()).append('\n');
            LOG.info(stringBuilder.toString());
            LOG.info("mangoo I/O application started @{}:{} in {} ms in {} mode. Enjoy.", new Object[]{this.host, this.port, ChronoUnit.MILLIS.between(this.start, LocalDateTime.now()), this.mode.toString()});
        }
    }

    public void applicationStarted() {
        ((MangooLifecycle)this.injector.getInstance(MangooLifecycle.class)).applicationStarted();
    }

    public void startQuartzScheduler() {
        Set set;
        if (!this.hasError() && (set = new Reflections(this.config.getSchedulerPackage(), new Scanner[0]).getTypesAnnotatedWith(Schedule.class)) != null && !set.isEmpty() && this.config.isSchedulerAutostart()) {
            Scheduler scheduler = (Scheduler)this.injector.getInstance(Scheduler.class);
            set.forEach(clazz -> {
                Schedule schedule = clazz.getDeclaredAnnotation(Schedule.class);
                if (CronExpression.isValidExpression((String)schedule.cron())) {
                    JobDetail jobDetail = SchedulerUtils.createJobDetail(clazz.getName(), Default.SCHEDULER_JOB_GROUP.toString(), clazz.asSubclass(Job.class));
                    Trigger trigger = SchedulerUtils.createTrigger(clazz.getName() + "-trigger", Default.SCHEDULER_TRIGGER_GROUP.toString(), schedule.description(), schedule.cron());
                    scheduler.schedule(jobDetail, trigger);
                    LOG.info("Successfully scheduled job " + clazz.getName() + " with cron " + schedule.cron());
                } else {
                    LOG.error("Invalid or missing cron expression for job: " + clazz.getName());
                    this.error = true;
                }
            });
            if (!this.hasError()) {
                scheduler.start();
            }
        }
    }

    public boolean isBootstrapSuccessful() {
        return !this.error;
    }

    private boolean hasError() {
        return this.error;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    private String getValidPackage(String string) {
        Objects.requireNonNull(string, "package name can not be null");
        if (!string.endsWith(".")) {
            return string + '.';
        }
        return string;
    }
}

