/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.crypto;

import com.google.common.base.Charsets;
import com.google.inject.Singleton;
import io.mangoo.configuration.Config;
import io.mangoo.core.Application;
import io.mangoo.enums.Key;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Base64;

@Singleton
public class Crypto {
    private static final Logger LOG = LogManager.getLogger(Crypto.class);
    private static final Config CONFIG = Application.getConfig();
    private static final int KEYINDEX_START = 0;
    private static final int KEYLENGTH_16 = 16;
    private static final int KEYLENGTH_24 = 24;
    private static final int KEYLENGTH_32 = 32;
    private final PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()));
    private CipherParameters cipherParameters;

    public String decrypt(String string) {
        Objects.requireNonNull(string, "encrytedText can not be null");
        return this.decrypt(string, this.getSizedKey(CONFIG.getString(Key.APPLICATION_SECRET)));
    }

    public String decrypt(String string, String string2) {
        Objects.requireNonNull(string, "encrytedText can not be null");
        Objects.requireNonNull(string2, "key can not be null");
        this.cipherParameters = new ParametersWithIV((CipherParameters)new KeyParameter(this.getSizedKey(string2).getBytes(Charsets.UTF_8)), new byte[16]);
        this.cipher.init(false, this.cipherParameters);
        return new String(this.cipherData(Base64.decode((String)string)), Charsets.UTF_8);
    }

    public String encrypt(String string) {
        Objects.requireNonNull(string, "plainText can not be null");
        return this.encrypt(string, this.getSizedKey(CONFIG.getApplicationSecret()));
    }

    public String encrypt(String string, String string2) {
        Objects.requireNonNull(string, "plainText can not be null");
        Objects.requireNonNull(string2, "key can not be null");
        this.cipherParameters = new ParametersWithIV((CipherParameters)new KeyParameter(this.getSizedKey(string2).getBytes(Charsets.UTF_8)), new byte[16]);
        this.cipher.init(true, this.cipherParameters);
        return new String(Base64.encode((byte[])this.cipherData(string.getBytes(Charsets.UTF_8))), Charsets.UTF_8);
    }

    private byte[] cipherData(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            byte[] byArray3 = new byte[this.cipher.getOutputSize(byArray.length)];
            int n = this.cipher.processBytes(byArray, 0, byArray.length, byArray3, 0);
            int n2 = this.cipher.doFinal(byArray3, n);
            byArray2 = new byte[n + n2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        }
        catch (CryptoException cryptoException) {
            LOG.error("Failed to encrypt/decrypt", (Throwable)cryptoException);
        }
        return byArray2;
    }

    private String getSizedKey(String string) {
        String string2 = "";
        if (StringUtils.isNotBlank((CharSequence)string)) {
            if (string.length() >= 32) {
                string2 = string.substring(0, 32);
            } else if (string.length() >= 24) {
                string2 = string.substring(0, 24);
            } else if (string.length() >= 16) {
                string2 = string.substring(0, 16);
            }
        }
        return string2;
    }
}

