/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.filters.oauth;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.mangoo.enums.Default;
import io.mangoo.enums.oauth.OAuthProvider;
import io.mangoo.enums.oauth.OAuthResource;
import io.mangoo.interfaces.MangooFilter;
import io.mangoo.models.OAuthUser;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.utils.RequestUtils;
import org.apache.commons.lang3.StringUtils;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class OAuthCallbackFilter
implements MangooFilter {
    private static final String PROFILE_IMAGE_URL_HTTPS = "$.profile_image_url_https";
    private static final String SCREEN_NAME = "$.screen_name";
    private static final String PICTURE = "$.picture";
    private static final String PICTURE_DATA_URL = "$.picture.data.url";
    private static final String NAME = "$.name";
    private static final String ID = "$.id";
    private static final String OAUTH_VERIFIER = "oauth_verifier";
    private static final String OAUTH_TOKEN = "oauth_token";
    private static final String CODE = "code";

    @Override
    public Response execute(Request request, Response response) {
        OAuthProvider oAuthProvider = RequestUtils.getOAuthProvider(request.getParameter(Default.OAUTH_REQUEST_PARAMETER.toString()));
        switch (oAuthProvider) {
            case TWITTER: {
                this.twitterOAuth(request);
                break;
            }
            case GOOGLE: {
                this.googleOAuth(request);
                break;
            }
            case FACEBOOK: {
                this.facebookOAuth(request);
                break;
            }
        }
        return response;
    }

    private void facebookOAuth(Request request) {
        String string = request.getParameter(CODE);
        OAuthService oAuthService = RequestUtils.createOAuthService(OAuthProvider.FACEBOOK);
        if (StringUtils.isNotBlank((CharSequence)string) && oAuthService != null) {
            Verifier verifier = new Verifier(string);
            Token token = oAuthService.getAccessToken(null, verifier);
            org.scribe.model.Response response = this.getResourceResponse(oAuthService, token, OAuthResource.FACEBOOK.toString());
            String string2 = response.getBody();
            if (response.isSuccessful() && StringUtils.isNotBlank((CharSequence)string2)) {
                DocumentContext documentContext = JsonPath.parse((String)string2);
                request.getAuthentication().setOAuthUser(new OAuthUser((String)documentContext.read(ID, new Predicate[0]), string2, (String)documentContext.read(NAME, new Predicate[0]), (String)documentContext.read(PICTURE_DATA_URL, new Predicate[0])));
            }
        }
    }

    private void googleOAuth(Request request) {
        String string = request.getParameter(CODE);
        OAuthService oAuthService = RequestUtils.createOAuthService(OAuthProvider.GOOGLE);
        if (StringUtils.isNotBlank((CharSequence)string) && oAuthService != null) {
            Verifier verifier = new Verifier(string);
            Token token = oAuthService.getAccessToken(null, verifier);
            org.scribe.model.Response response = this.getResourceResponse(oAuthService, token, OAuthResource.GOOGLE.toString());
            String string2 = response.getBody();
            if (response.isSuccessful() && StringUtils.isNotBlank((CharSequence)string2)) {
                DocumentContext documentContext = JsonPath.parse((String)response.getBody());
                request.getAuthentication().setOAuthUser(new OAuthUser((String)documentContext.read(ID, new Predicate[0]), string2, (String)documentContext.read(NAME, new Predicate[0]), (String)documentContext.read(PICTURE, new Predicate[0])));
            }
        }
    }

    private void twitterOAuth(Request request) {
        String string = request.getParameter(OAUTH_TOKEN);
        String string2 = request.getParameter(OAUTH_VERIFIER);
        OAuthService oAuthService = RequestUtils.createOAuthService(OAuthProvider.TWITTER);
        if (StringUtils.isNotBlank((CharSequence)string) && StringUtils.isNotBlank((CharSequence)string2) && oAuthService != null) {
            Token token = new Token(string, string2);
            Verifier verifier = new Verifier(string2);
            Token token2 = oAuthService.getAccessToken(token, verifier);
            org.scribe.model.Response response = this.getResourceResponse(oAuthService, token2, OAuthResource.TWITTER.toString());
            String string3 = response.getBody();
            if (response.isSuccessful() && StringUtils.isNotBlank((CharSequence)string3)) {
                DocumentContext documentContext = JsonPath.parse((String)response.getBody());
                request.getAuthentication().setOAuthUser(new OAuthUser((String)documentContext.read(ID, new Predicate[0]), response.getBody(), (String)documentContext.read(SCREEN_NAME, new Predicate[0]), (String)documentContext.read(PROFILE_IMAGE_URL_HTTPS, new Predicate[0])));
            }
        }
    }

    private org.scribe.model.Response getResourceResponse(OAuthService oAuthService, Token token, String string) {
        OAuthRequest oAuthRequest = new OAuthRequest(Verb.GET, string);
        oAuthService.signRequest(token, oAuthRequest);
        return oAuthRequest.send();
    }
}

