/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.filters.oauth;

import io.mangoo.enums.Default;
import io.mangoo.enums.oauth.OAuthProvider;
import io.mangoo.interfaces.MangooFilter;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Request;
import io.mangoo.utils.RequestUtils;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.scribe.model.Token;
import org.scribe.oauth.OAuthService;

public class OAuthLoginFilter
implements MangooFilter {
    @Override
    public Response execute(Request request, Response response) {
        OAuthService oAuthService;
        OAuthProvider oAuthProvider = RequestUtils.getOAuthProvider(request.getParameter(Default.OAUTH_REQUEST_PARAMETER.toString()));
        if (oAuthProvider != null && (oAuthService = RequestUtils.createOAuthService(oAuthProvider)) != null) {
            String string = null;
            switch (oAuthProvider) {
                case TWITTER: {
                    Token token = oAuthService.getRequestToken();
                    string = oAuthService.getAuthorizationUrl(token);
                    break;
                }
                case GOOGLE: 
                case FACEBOOK: {
                    string = oAuthService.getAuthorizationUrl(null);
                    break;
                }
            }
            if (StringUtils.isNotBlank(string)) {
                return Response.withRedirect(URI.create(string).toString()).end();
            }
        }
        return response;
    }
}

