/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.managers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.cache.Cache;
import io.mangoo.enums.Default;
import io.mangoo.utils.RequestUtils;
import io.undertow.server.handlers.sse.ServerSentEventConnection;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.IOUtils;

@Singleton
public class ServerEventManager {
    private static final String URI_ERROR = "uri can not be null";
    private final Cache cache;

    @Inject
    public ServerEventManager(Cache cache) {
        this.cache = Objects.requireNonNull(cache, "cache can not be null");
    }

    public void addConnection(ServerSentEventConnection serverSentEventConnection) {
        Objects.requireNonNull(serverSentEventConnection, "connection can not be null");
        String string = RequestUtils.getServerSentEventURL(serverSentEventConnection);
        Set<ServerSentEventConnection> set = this.getConnections(string);
        if (set == null) {
            set = new HashSet<ServerSentEventConnection>();
            set.add(serverSentEventConnection);
        } else {
            set.add(serverSentEventConnection);
        }
        this.setConnections(string, set);
    }

    public void send(String string, String string2) {
        Objects.requireNonNull(string, URI_ERROR);
        Set<ServerSentEventConnection> set = this.getConnections(string);
        if (set != null) {
            set.forEach(serverSentEventConnection -> {
                if (serverSentEventConnection.isOpen()) {
                    serverSentEventConnection.send(string2);
                }
            });
        }
    }

    public void send(String string, String string2, ServerSentEventConnection.EventCallback eventCallback) {
        Objects.requireNonNull(string, URI_ERROR);
        Objects.requireNonNull(eventCallback, "eventCallback can not be null");
        Set<ServerSentEventConnection> set = this.getConnections(string);
        if (set != null) {
            set.forEach(serverSentEventConnection -> {
                if (serverSentEventConnection.isOpen()) {
                    serverSentEventConnection.send(string2, eventCallback);
                }
            });
        }
    }

    public void close(String string) {
        Objects.requireNonNull(string, URI_ERROR);
        Set<ServerSentEventConnection> set = this.getConnections(string);
        if (set != null) {
            set.forEach(serverSentEventConnection -> {
                if (serverSentEventConnection.isOpen()) {
                    IOUtils.closeQuietly((Closeable)serverSentEventConnection);
                }
            });
            this.removeConnections(string);
        }
    }

    public Set<ServerSentEventConnection> getConnections(String string) {
        Objects.requireNonNull(string, URI_ERROR);
        Set set = (Set)this.cache.get(Default.SSE_CACHE_PREFIX.toString() + string);
        return set == null ? new HashSet() : set;
    }

    public void setConnections(String string, Set<ServerSentEventConnection> set) {
        Objects.requireNonNull(string, URI_ERROR);
        Objects.requireNonNull(set, "uriConnections can not be null");
        this.cache.put(Default.SSE_CACHE_PREFIX.toString() + string, set);
    }

    public void removeConnections(String string) {
        Objects.requireNonNull(string, URI_ERROR);
        this.cache.remove(Default.SSE_CACHE_PREFIX.toString() + string);
    }
}

