/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.managers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.mangoo.cache.Cache;
import io.mangoo.enums.Default;
import io.mangoo.utils.RequestUtils;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.IOUtils;

@Singleton
public class WebSocketManager {
    private static final String URI_ERROR = "uri can not be null";
    private final Cache cache;

    @Inject
    public WebSocketManager(Cache cache) {
        this.cache = Objects.requireNonNull(cache, "cache ca not be null");
    }

    public void addChannel(WebSocketChannel webSocketChannel) {
        Objects.requireNonNull(webSocketChannel, "channel can not be null");
        String string = RequestUtils.getWebSocketURL(webSocketChannel);
        Set<WebSocketChannel> set = this.getChannels(string);
        if (set == null) {
            set = new HashSet<WebSocketChannel>();
            set.add(webSocketChannel);
        } else {
            set.add(webSocketChannel);
        }
        this.setChannels(string, set);
    }

    public void setChannels(String string, Set<WebSocketChannel> set) {
        Objects.requireNonNull(string, URI_ERROR);
        Objects.requireNonNull(set, "uriConnections can not be null");
        this.cache.put(Default.WSS_CACHE_PREFIX.toString() + string, set);
    }

    public Set<WebSocketChannel> getChannels(String string) {
        Objects.requireNonNull(string, URI_ERROR);
        Set set = (Set)this.cache.get(Default.WSS_CACHE_PREFIX.toString() + string);
        return set == null ? new HashSet() : set;
    }

    public void removeChannels(String string) {
        Objects.requireNonNull(string, URI_ERROR);
        this.cache.remove(Default.WSS_CACHE_PREFIX.toString() + string);
    }

    public void close(String string) {
        Objects.requireNonNull(string, URI_ERROR);
        Set<WebSocketChannel> set = this.getChannels(string);
        if (set != null) {
            set.forEach(webSocketChannel -> {
                if (webSocketChannel.isOpen()) {
                    IOUtils.closeQuietly((Closeable)webSocketChannel);
                }
            });
            this.removeChannels(string);
        }
    }
}

