/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing;

import io.mangoo.authentication.Authentication;
import io.mangoo.crypto.Crypto;
import io.mangoo.i18n.Messages;
import io.mangoo.routing.Response;
import io.mangoo.routing.bindings.Flash;
import io.mangoo.routing.bindings.Form;
import io.mangoo.routing.bindings.Request;
import io.mangoo.routing.bindings.Session;
import io.mangoo.templating.TemplateEngine;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;

public class Attachment {
    private final long start = System.currentTimeMillis();
    private int methodParametersCount;
    private Class<?> controllerClass;
    private Object controllerInstance;
    private Map<String, Class<?>> methodParameters;
    private String controllerClassName;
    private String controllerMethodName;
    private String body;
    private Method method;
    private Authentication authentication;
    private Session session;
    private Flash flash;
    private Form form;
    private Request request;
    private Response response;
    private Map<String, String> requestParameter;
    private Crypto crypto;
    private Messages messages;
    private TemplateEngine templateEngine;
    private boolean requestFilter;

    public static Attachment build() {
        return new Attachment();
    }

    public Attachment withControllerClass(Class<?> clazz) {
        this.controllerClass = Objects.requireNonNull(clazz, "controllerClass can not be null");
        return this;
    }

    public Attachment withControllerClassName(String string) {
        this.controllerClassName = Objects.requireNonNull(string, "controllerClassName can not be null");
        return this;
    }

    public Attachment withControllerMethodName(String string) {
        this.controllerMethodName = Objects.requireNonNull(string, "controllerMethodName can not be null");
        return this;
    }

    public Attachment withControllerInstance(Object object) {
        this.controllerInstance = Objects.requireNonNull(object, "controllerInstance can no be null");
        return this;
    }

    public Attachment withCrypto(Crypto crypto) {
        this.crypto = Objects.requireNonNull(crypto, "crypto can no be null");
        return this;
    }

    public Attachment withMethodParameters(Map<String, Class<?>> map) {
        this.methodParameters = Objects.requireNonNull(map, "methodParameters can no be null");
        return this;
    }

    public Attachment withMessages(Messages messages) {
        this.messages = Objects.requireNonNull(messages, "messages can no be null");
        return this;
    }

    public Attachment withTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine can no be null");
        return this;
    }

    public Attachment withRequestParameter(Map<String, String> map) {
        this.requestParameter = Objects.requireNonNull(map, "requestParameter can no be null");
        return this;
    }

    public Attachment withMethod(Method method) {
        this.method = Objects.requireNonNull(method, "method can no be null");
        return this;
    }

    public Attachment withMethodParameterCount(int n) {
        this.methodParametersCount = n;
        return this;
    }

    public Attachment withRequestFilter(boolean bl) {
        this.requestFilter = bl;
        return this;
    }

    public Messages getMessages() {
        return this.messages;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setFlash(Flash flash) {
        this.flash = flash;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public Session getSession() {
        return this.session;
    }

    public Flash getFlash() {
        return this.flash;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public boolean hasRequestFilter() {
        return this.requestFilter;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public Request getRequest() {
        return this.request;
    }

    public Map<String, Class<?>> getMethodParameters() {
        return this.methodParameters;
    }

    public Object getControllerInstance() {
        return this.controllerInstance;
    }

    public TemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public Form getForm() {
        return this.form;
    }

    public String getControllerClassName() {
        return this.controllerClassName;
    }

    public String getControllerMethodName() {
        return this.controllerMethodName;
    }

    public int getMethodParametersCount() {
        return this.methodParametersCount;
    }

    public Map<String, String> getRequestParameter() {
        return this.requestParameter;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.body = string;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Response getResponse() {
        return this.response;
    }

    public long getResponseTime() {
        return System.currentTimeMillis() - this.start;
    }
}

