/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import com.google.common.collect.ImmutableMap;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import io.mangoo.authentication.Authentication;
import io.mangoo.core.Application;
import io.mangoo.interfaces.MangooValidator;
import io.mangoo.routing.bindings.Session;
import io.mangoo.routing.bindings.Validator;
import io.mangoo.utils.JsonUtils;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Request
implements MangooValidator {
    private HttpServerExchange httpServerExchange;
    private String body;
    private Session session;
    private String authenticityToken;
    private Authentication authentication;
    private Validator validator;
    private Map<String, String> parameter;
    private Map<String, Cookie> cookies;

    public Request() {
    }

    public Request(HttpServerExchange httpServerExchange, Session session, String string, Authentication authentication, Map<String, String> map, String string2) {
        Objects.requireNonNull(httpServerExchange, "httpServerExchange can not be null");
        this.httpServerExchange = httpServerExchange;
        this.session = session;
        this.authenticityToken = string;
        this.authentication = authentication;
        this.body = string2;
        this.parameter = map;
        this.validator = Application.getInstance(Validator.class);
        this.validator.setValues(this.parameter);
        this.cookies = httpServerExchange.getRequestCookies() == null ? new HashMap() : ImmutableMap.copyOf((Map)httpServerExchange.getRequestCookies());
    }

    public Session getSession() {
        return this.session;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, Object> getBodyAsJsonMap() {
        return JsonUtils.fromJson(this.body, Map.class);
    }

    public ReadContext getBodyAsJsonPath() {
        return JsonPath.parse((String)this.body);
    }

    public boolean authenticityMatches() {
        return this.session.getAuthenticityToken().equals(this.authenticityToken);
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public String getParameter(String string) {
        return this.parameter.get(string);
    }

    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public HeaderMap getHeaders() {
        return this.httpServerExchange.getRequestHeaders();
    }

    public String getAcceptLanguage() {
        return this.getHeader(Headers.ACCEPT_LANGUAGE);
    }

    public String getHeader(HttpString httpString) {
        return this.httpServerExchange.getRequestHeaders().get(httpString) == null ? null : this.httpServerExchange.getRequestHeaders().get(httpString).element();
    }

    public String getURI() {
        return this.httpServerExchange.getRequestURI();
    }

    public String getURL() {
        return this.httpServerExchange.getRequestURL();
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public Cookie getCookie(String string) {
        return this.cookies.get(string);
    }

    public String getScheme() {
        return this.httpServerExchange.getRequestScheme();
    }

    public String getCharset() {
        return this.httpServerExchange.getRequestCharset();
    }

    public long getContentLength() {
        return this.httpServerExchange.getRequestContentLength();
    }

    public HttpString getMethod() {
        return this.httpServerExchange.getRequestMethod();
    }

    public String getPath() {
        return this.httpServerExchange.getRequestPath();
    }

    @Override
    public Validator validation() {
        return this.validator;
    }

    @Override
    public String getError(String string) {
        return this.validator.hasError(string) ? this.validator.getError(string) : "";
    }
}

