/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.routing.bindings;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Session {
    private static final Logger LOG = LogManager.getLogger(Session.class);
    private static final List<String> blacklist = Arrays.asList("|", ":", "&", " ");
    private Map<String, String> values;
    private String authenticityToken;
    private boolean changed;
    private LocalDateTime expires;

    public Session() {
    }

    public Session(Map<String, String> map, String string, LocalDateTime localDateTime) {
        this.values = Optional.ofNullable(map).orElse(new HashMap());
        this.authenticityToken = string;
        this.expires = localDateTime;
    }

    public boolean hasContent() {
        return !this.values.isEmpty();
    }

    public String get(String string) {
        return this.values.get(string);
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public LocalDateTime getExpires() {
        return this.expires;
    }

    public void put(String string, String string2) {
        if (blacklist.contains(string) || blacklist.contains(string2)) {
            LOG.error("Session key or value can not contain the following characters: spaces, |, & or :");
        } else {
            this.changed = true;
            this.values.put(string, string2);
        }
    }

    public void remove(String string) {
        this.changed = true;
        this.values.remove(string);
    }

    public void clear() {
        this.changed = true;
        this.values = new HashMap<String, String>();
    }

    public boolean hasChanges() {
        return this.changed;
    }

    public String getAuthenticityToken() {
        this.changed = true;
        return this.authenticityToken;
    }
}

